/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.generator.AbstractResourcesGenerator;
import com.boozallen.aiops.mda.generator.common.DataFlowStrategy;
import com.boozallen.aiops.mda.generator.common.SparkStorageEnum;
import com.boozallen.aiops.mda.generator.config.deployment.spark.SparkDependencyConfiguration;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.BaseFileStoreDecorator;
import com.boozallen.aiops.mda.metamodel.element.FileStore;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.java.JavaPipeline;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPipeline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class SparkApplicationGenerator
extends AbstractResourcesGenerator {
    protected ManualActionNotificationService manualActionNotificationService = new ManualActionNotificationService();
    private final SparkDependencyConfiguration config = SparkDependencyConfiguration.getInstance();
    protected static final String DOCKER_PROJECT_REPOSITORY_URL = "dockerProjectRepositoryUrl";

    private void handlePySpark(VelocityContext vc, GenerationContext context) {
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(context, this.metadataContext);
        PythonPipeline pythonTargetPipeline = new PythonPipeline(pipeline);
        String fileName = this.replace("pipelineName", context.getOutputFile(), pythonTargetPipeline.deriveArtifactIdFromCamelCase());
        context.setOutputFile(fileName);
        vc.put("sparkApplicationType", (Object)"Python");
        vc.put("mainApplicationFile", (Object)(pythonTargetPipeline.getKababCaseName() + "/" + pythonTargetPipeline.getSnakeCaseName() + "_driver.py"));
    }

    private void handleSpark(VelocityContext vc, GenerationContext context) {
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(context, this.metadataContext);
        JavaPipeline javaTargetPipeline = new JavaPipeline(pipeline);
        String fileName = this.replace("pipelineName", context.getOutputFile(), javaTargetPipeline.deriveArtifactIdFromCamelCase());
        context.setOutputFile(fileName);
        vc.put("sparkApplicationType", (Object)"Java");
        vc.put("isJavaPipeline", (Object)true);
        vc.put("mainApplicationFile", (Object)(context.getArtifactId() + ".jar"));
        vc.put("mainClass", (Object)(context.getBasePackage() + "." + javaTargetPipeline.getCapitalizedName() + "Driver"));
    }

    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        VelocityContext vc = this.getNewVelocityContext(context);
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(context, this.metadataContext);
        DataFlowStrategy dfs = new DataFlowStrategy(Collections.singletonList(pipeline));
        ArrayList<String> extensions = new ArrayList<String>();
        if (dfs.isDeltaSupportNeeded()) {
            extensions.add("io.delta.sql.DeltaSparkSessionExtension");
        }
        if (dfs.isSedonaSupportNeeded()) {
            extensions.add("org.apache.sedona.sql.SedonaSqlExtensions");
        }
        if ("test".equalsIgnoreCase(context.getArtifactType())) {
            vc.put("isTestResource", (Object)true);
        }
        vc.put("enablePySparkSupport", (Object)dfs.isPySparkSupportNeeded());
        vc.put("enableRDBMSSupport", (Object)dfs.isRdbmsSupportNeeded());
        vc.put("enableNeo4jSupport", (Object)dfs.isNeo4jSupportNeeded());
        vc.put("enableDeltaSupport", (Object)dfs.isDeltaSupportNeeded());
        vc.put("enableElasticsearchSupport", (Object)dfs.isElasticsearchSupportNeeded());
        vc.put("enableHiveSupport", (Object)dfs.isHiveSupportNeeded());
        vc.put("enableSedonaSupport", (Object)dfs.isSedonaSupportNeeded());
        vc.put("enableDataLineageSupport", (Object)dfs.isDataLineageNeeded());
        vc.put("sparkExtensions", (Object)String.join((CharSequence)",", extensions));
        vc.put("versionSpark", (Object)this.config.getSparkVersion());
        vc.put("versionDelta", (Object)this.config.getDeltaVersion());
        vc.put("versionElasticsearch", (Object)this.config.getElasticSearchVersion());
        vc.put("versionSedona", (Object)this.config.getSedonaVersion());
        vc.put("versionGeotools", (Object)this.config.getGeotoolsVersion());
        vc.put("versionPostgresql", (Object)this.config.getPostgresqlVersion());
        vc.put("versionMysqlConnector", (Object)this.config.getMysqlConnectorVersion());
        vc.put("versionHadoop", (Object)this.config.getHadoopVersion());
        vc.put("versionNeo4j", (Object)this.config.getNeo4jVersion());
        vc.put("versionAwsSdkBundle", (Object)this.config.getAwsSdkBundleVersion());
        if (pipeline.getType().getImplementation().equalsIgnoreCase("data-delivery-spark")) {
            this.handleSpark(vc, context);
        } else if (pipeline.getType().getImplementation().equalsIgnoreCase("data-delivery-pyspark")) {
            this.handlePySpark(vc, context);
        } else {
            throw new IllegalArgumentException("Invalid implementation form: " + pipeline.getType().getImplementation());
        }
        String projectName = context.getRootArtifactId();
        String dockerProjectRepositoryUrl = (String)context.getPropertyVariables().get(DOCKER_PROJECT_REPOSITORY_URL);
        vc.put("sparkApplicationName", (Object)context.getArtifactId());
        vc.put("projectName", (Object)projectName);
        vc.put("pipeline", (Object)pipeline.getName());
        vc.put(DOCKER_PROJECT_REPOSITORY_URL, (Object)dockerProjectRepositoryUrl);
        List<FileStore> fileStores = pipeline.getFileStores();
        boolean enableFileStore = !fileStores.isEmpty();
        vc.put("enableFileStore", (Object)enableFileStore);
        if (enableFileStore) {
            ArrayList<BaseFileStoreDecorator> decoratedStores = new ArrayList<BaseFileStoreDecorator>();
            for (FileStore fileStore : fileStores) {
                BaseFileStoreDecorator decoratedStore = new BaseFileStoreDecorator(fileStore);
                decoratedStores.add(decoratedStore);
            }
            vc.put("fileStores", decoratedStores);
        }
        if (!"test".equalsIgnoreCase(context.getArtifactType()) && SparkStorageEnum.S3LOCAL == metamodelRepository.getDeploymentConfigurationManager().getSparkDeploymentConfiguration().getStorageType()) {
            vc.put("useS3Local", (Object)true);
            this.manualActionNotificationService.addDeployPomMessage(context, "s3local-deploy-v2", "s3-local");
            this.manualActionNotificationService.addPipelineInvocationServiceDeployment(context);
            this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(context, "pipeline-invocation");
            this.manualActionNotificationService.addNoticeToUpdateS3LocalConfig(context, "spark-infrastructure", Arrays.asList("warehouse/"));
        }
        this.generateFile(context, vc);
    }
}

