/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.common.DataFlowStrategy;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.generator.util.SemanticDataUtil;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class SparkDockerPomGenerator
extends AbstractMavenModuleGenerator {
    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        String basefileName = context.getOutputFile();
        basefileName = this.replaceBasePackage(basefileName, context.getBasePackageAsPath());
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        DataFlowStrategy dataFlowStrategy = new DataFlowStrategy(pipelines);
        List<Pipeline> dataFlowPipelines = dataFlowStrategy.getPipelines();
        if (!dataFlowPipelines.isEmpty()) {
            VelocityContext vc = new VelocityContext();
            String rootArtifactId = context.getRootArtifactId();
            String sparkDockerArtifactId = context.getArtifactId().replace("-docker", "-spark-worker-docker");
            String pipelinesArtifactId = context.getArtifactId().replace("-docker", "-pipelines");
            vc.put("rootArtifactId", (Object)rootArtifactId);
            vc.put("groupId", (Object)context.getGroupId());
            vc.put("parentArtifactId", (Object)context.getArtifactId());
            vc.put("version", (Object)context.getVersion());
            vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
            vc.put("artifactId", (Object)sparkDockerArtifactId);
            vc.put("pipelineArtifactIds", dataFlowStrategy.getArtifactIds());
            vc.put("sparkPipelines", dataFlowStrategy.getSparkPipelines());
            vc.put("pysparkPipelines", dataFlowStrategy.getPySparkPipelines());
            vc.put("enablePySparkSupport", (Object)dataFlowStrategy.isPySparkSupportNeeded());
            MachineLearningStrategy machineLearningStrategy = new MachineLearningStrategy(pipelines);
            boolean postgresSupportIsNeeded = dataFlowStrategy.isPostgresSupportNeeded() || machineLearningStrategy.isPostgresSupportNeeded() || dataFlowStrategy.isRdbmsSupportNeeded() || machineLearningStrategy.isRdbmsSupportNeeded();
            vc.put("enablePostgresSupport", (Object)postgresSupportIsNeeded);
            vc.put("enableRDBMSSupport", (Object)postgresSupportIsNeeded);
            vc.put("enableSedonaSupport", (Object)dataFlowStrategy.isSedonaSupportNeeded());
            vc.put("enableSemanticDataSupport", (Object)SemanticDataUtil.hasSemanticDataByContext(this.metadataContext));
            String fileName = this.replace("moduleArtifactId", basefileName, sparkDockerArtifactId);
            context.setOutputFile(fileName);
            this.generateFile(context, vc);
            String sparkOperatorAppName = "spark-operator";
            String sparkInfrastructureAppName = "spark-infrastructure";
            String sparkWorkerAppName = "spark-worker-image";
            this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, sparkDockerArtifactId, "docker");
            this.manualActionNotificationService.addDeployPomMessage(context, "aissemble-spark-operator-deploy-v2", "spark-operator");
            this.manualActionNotificationService.addDeployPomMessage(context, "aissemble-spark-infrastructure-deploy-v2", "spark-infrastructure");
            this.manualActionNotificationService.addDeployPomMessage(context, "aissemble-spark-worker-deploy", "spark-worker-image");
            this.manualActionNotificationService.addSparkWorkerDockerBuildTiltMessage(context, "spark-worker-image", sparkDockerArtifactId, context.getArtifactId());
            for (Pipeline pipeline : dataFlowPipelines) {
                String pipelineArtifactId = this.deriveArtifactIdFromCamelCase(pipeline.getName());
                this.manualActionNotificationService.addSparkWorkerTiltResources(context, pipelinesArtifactId, pipelineArtifactId, pipeline.getType().getImplementation());
                if (pipeline.getType().getImplementation().equalsIgnoreCase("data-delivery-pyspark")) {
                    this.manualActionNotificationService.addLocalResourceTiltFileMessage(context, context.getArtifactId(), sparkDockerArtifactId, pipelineArtifactId, pipelineArtifactId, false);
                    continue;
                }
                this.manualActionNotificationService.addSparkWorkerDockerBuildTiltMessage(context, "spark-worker-image", sparkDockerArtifactId, context.getArtifactId());
            }
            if (dataFlowStrategy.isMetadataNeeded()) {
                this.manualActionNotificationService.addDeployPomMessage(context, "metadata-deploy-v2", "metadata");
            }
            if (dataFlowStrategy.isElasticsearchSupportNeeded()) {
                this.manualActionNotificationService.addDeployPomMessage(context, "elasticsearch-operator-deploy-v2", "elasticsearch-operator");
                this.manualActionNotificationService.addDeployPomMessage(context, "elasticsearch-deploy-v2", "elasticsearch");
                this.manualActionNotificationService.addElasticsearchTiltResources(context, "elasticsearch", context.getArtifactId().replace("-docker", ""));
            }
            if (dataFlowStrategy.isNeo4jSupportNeeded()) {
                this.manualActionNotificationService.addDeployPomMessage(context, "neo4j-deploy", "neo4j");
            }
            if (dataFlowStrategy.isPostgresSupportNeeded() || dataFlowStrategy.isRdbmsSupportNeeded()) {
                this.manualActionNotificationService.addDeployPomMessage(context, "postgres-deploy", "postgres");
            }
        }
    }
}

