/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.generator.AbstractJavaGenerator;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.java.JavaPipeline;
import com.boozallen.aiops.mda.metamodel.element.java.JavaStep;
import java.util.ArrayList;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public class TargetedPipelineJavaGenerator
extends AbstractJavaGenerator {
    protected ManualActionNotificationService manualActionNotificationService = new ManualActionNotificationService();

    @Override
    public void generate(GenerationContext generationContext) {
        super.generate(generationContext);
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(generationContext, this.metadataContext);
        JavaPipeline javaTargetPipeline = new JavaPipeline(pipeline);
        vc.put("pipeline", (Object)javaTargetPipeline);
        vc.put("artifactId", (Object)javaTargetPipeline.deriveArtifactIdFromCamelCase());
        String baseOutputFile = generationContext.getOutputFile();
        String fileName = this.replace("pipelineName", baseOutputFile, javaTargetPipeline.getName());
        generationContext.setOutputFile(fileName);
        ArrayList<JavaStep> javaSteps = new ArrayList<JavaStep>();
        for (Step step : javaTargetPipeline.getSteps()) {
            JavaStep javaStep = new JavaStep(step);
            javaSteps.add(javaStep);
        }
        vc.put("steps", javaSteps);
        this.generateFile(generationContext, vc);
        if (javaTargetPipeline.hasMessaging()) {
            for (JavaStep javaStep : javaTargetPipeline.getMessagingSteps()) {
                if (javaStep.hasMessagingInbound()) {
                    this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(generationContext, javaStep.getInbound().getChannelName());
                }
                if (!javaStep.hasMessagingOutbound()) continue;
                this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(generationContext, javaStep.getOutbound().getChannelName());
            }
        }
        if (javaTargetPipeline.isAlertingSupportNeeded()) {
            this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(generationContext, "alerts");
        }
        if (javaTargetPipeline.isMetadataNeeded()) {
            this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(generationContext, "metadata-ingest");
        }
        if (javaTargetPipeline.getDataLineage()) {
            this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(generationContext, "lineage-event-out");
        }
    }
}

