/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.generator.AbstractPythonGenerator;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPipeline;
import com.boozallen.aiops.mda.metamodel.element.python.PythonStep;
import java.util.ArrayList;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public class TargetedPipelinePythonMainGenerator
extends AbstractPythonGenerator {
    protected ManualActionNotificationService manualActionNotificationService = new ManualActionNotificationService();

    public void generate(GenerationContext generationContext) {
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(generationContext, this.metadataContext);
        PythonPipeline pythonTargetPipeline = new PythonPipeline(pipeline);
        String originalTemplateName = generationContext.getTemplateName();
        String pipelineImplementation = pipeline.getType().getImplementation();
        String pipelineSpecificTemplateName = this.replace("pipelineImplementation", originalTemplateName, pipelineImplementation);
        generationContext.setTemplateName(pipelineSpecificTemplateName);
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        vc.put("pipeline", (Object)pythonTargetPipeline);
        vc.put("artifactIdPythonCase", (Object)this.toPythonCase(generationContext.getArtifactId()));
        ArrayList<PythonStep> pythonSteps = new ArrayList<PythonStep>();
        for (Step step : pythonTargetPipeline.getSteps()) {
            PythonStep pythonStep = new PythonStep(step);
            if (pythonTargetPipeline.getStepByType("inference") != null) {
                if (!pythonStep.getType().equalsIgnoreCase("generic")) continue;
                pythonSteps.add(pythonStep);
                continue;
            }
            pythonSteps.add(pythonStep);
        }
        if (pythonTargetPipeline.getDataLineage()) {
            this.manualActionNotificationService.addNoticeToUpdateKafkaConfig(generationContext, "lineage-event-out");
        }
        vc.put("steps", pythonSteps);
        String baseOutputFile = generationContext.getOutputFile();
        String string = this.replace("pipelineName", baseOutputFile, pythonTargetPipeline.getSnakeCaseName());
        generationContext.setOutputFile(string);
        this.generateFile(generationContext, vc);
    }

    private String toPythonCase(String toConvert) {
        return PipelineUtils.deriveLowerSnakeCaseNameFromHyphenatedString(toConvert);
    }
}

