/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractPythonGenerator;
import com.boozallen.aiops.mda.generator.util.MavenUtil;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPipeline;
import com.boozallen.aiops.mda.metamodel.element.python.PythonStep;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public abstract class TargetedPipelineStepPythonGenerator
extends AbstractPythonGenerator {
    public void generate(GenerationContext generationContext) {
        String baseOutputFile = generationContext.getOutputFile();
        Pipeline pipeline = PipelineUtils.getTargetedPipeline(generationContext, this.metadataContext);
        PythonPipeline pythonTargetPipeline = new PythonPipeline(pipeline);
        pythonTargetPipeline.validate();
        for (Step step : pythonTargetPipeline.getSteps()) {
            if (!this.shouldGenerateStep(step, generationContext)) continue;
            VelocityContext vc = this.getNewVelocityContext(generationContext);
            String profileName = MavenUtil.getPySparkDataDeliveryProfileName(generationContext);
            PythonStep pythonStep = new PythonStep(step);
            pythonStep.validate();
            pythonStep.setProfileName(profileName);
            pythonStep.setRootArtifactId(generationContext.getRootArtifactId());
            vc.put("step", (Object)pythonStep);
            vc.put("pipeline", (Object)pythonTargetPipeline);
            String fileName = this.replace("name", baseOutputFile, pythonStep.getLowercaseSnakeCaseName());
            generationContext.setOutputFile(fileName);
            this.generateFile(generationContext, vc);
        }
    }

    protected boolean shouldGenerateStep(Step step, GenerationContext generationContext) {
        return true;
    }
}

