/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.DockerBuildParams;
import com.boozallen.aiops.mda.generator.AbstractMavenModuleGenerator;
import com.boozallen.aiops.mda.generator.MlflowDockerModuleGenerator;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.generator.common.PipelineStepPair;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class TrainingDockerModuleGenerator
extends AbstractMavenModuleGenerator {
    private static final String APP_NAME = "training";

    public void generate(GenerationContext context) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
        MachineLearningStrategy mlStrategy = new MachineLearningStrategy(pipelines);
        List<String> trainingModules = mlStrategy.getTrainingModules();
        if (!trainingModules.isEmpty()) {
            List<PipelineStepPair> pipelineStepPairs = mlStrategy.getSteps();
            String basefileName = context.getOutputFile();
            for (PipelineStepPair pipelineStepPair : pipelineStepPairs) {
                VelocityContext vc = this.getNewVelocityContext(context);
                String rootArtifactId = context.getRootArtifactId();
                String trainingDockerArtifactId = this.getArtifactId(context, pipelineStepPair);
                String trainingModule = this.deriveArtifactIdFromCamelCase(pipelineStepPair.getStep().getName());
                vc.put("rootArtifactId", (Object)rootArtifactId);
                vc.put("artifactId", (Object)trainingDockerArtifactId);
                vc.put("basePackage", (Object)context.getBasePackage());
                vc.put("parentArtifactId", (Object)context.getArtifactId());
                vc.put("parentDescriptiveName", (Object)context.getDescriptiveName());
                vc.put("trainingPipeline", (Object)pipelineStepPair);
                vc.put("trainingModuleSnakeCase", (Object)PipelineUtils.deriveLowerSnakeCaseNameFromHyphenatedString(trainingModule));
                String fileName = this.replace("moduleArtifactId", basefileName, trainingDockerArtifactId);
                context.setOutputFile(fileName);
                this.generateFile(context, vc);
                this.manualActionNotificationService.addNoticeToAddModuleToParentBuild(context, trainingDockerArtifactId, "docker");
                DockerBuildParams params = new DockerBuildParams.ParamBuilder().setContext(context).setAppName(trainingDockerArtifactId).setDockerApplicationArtifactId(trainingDockerArtifactId).setDockerArtifactId(context.getArtifactId()).setDeployedAppName(trainingDockerArtifactId).setIncludeHelmBuild(false).setIncludeLatestTag(true).build();
                this.manualActionNotificationService.addDockerBuildTiltFileMessage(params);
                String pipelineModule = this.deriveArtifactIdFromCamelCase(pipelineStepPair.getPipeline().getName());
                this.manualActionNotificationService.addLocalResourceTiltFileMessage(context, context.getArtifactId(), trainingDockerArtifactId, trainingModule, pipelineModule + "/" + trainingModule, true);
                this.manualActionNotificationService.addDeployPomMessage(context, "training-job", trainingModule + "-image");
            }
            this.manualActionNotificationService.addDeployPomMessage(context, "training-deploy", "model-training-api");
            MlflowDockerModuleGenerator.generateManualMessage(context, mlStrategy);
        }
    }

    protected String getArtifactId(GenerationContext context, PipelineStepPair pipelineStepPair) {
        return context.getArtifactId().replace("-docker", "-" + this.deriveArtifactIdFromCamelCase(pipelineStepPair.getStep().getName()) + "-docker");
    }
}

