/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator;

import com.boozallen.aiops.mda.generator.AbstractResourcesGenerator;
import com.boozallen.aiops.mda.generator.common.MachineLearningStrategy;
import com.boozallen.aiops.mda.generator.common.PipelineStepPair;
import com.boozallen.aiops.mda.generator.util.PythonGeneratorUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class TrainingDockerResourcesGenerator
extends AbstractResourcesGenerator {
    private static final Logger logger = LoggerFactory.getLogger(TrainingDockerResourcesGenerator.class);

    public void generate(GenerationContext context) {
        String rootModuleName = context.getRootArtifactId();
        if (rootModuleName == null || rootModuleName.isEmpty()) {
            logger.error("Root module could not be determined!");
        } else {
            String trainingModule = context.getArtifactId().replace(rootModuleName + "-", "").replace("-docker", "");
            VelocityContext vc = this.getNewVelocityContext(context);
            vc.put("trainingModule", (Object)trainingModule);
            vc.put("trainingModuleSnakeCase", (Object)PythonGeneratorUtils.normalizeToPythonCase(trainingModule));
            AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
            Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(this.metadataContext);
            ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>(pipelineMap.values());
            MachineLearningStrategy mlStrategy = new MachineLearningStrategy(pipelines);
            List<PipelineStepPair> pipelineStepPairs = mlStrategy.getSteps();
            String trainingPipeline = "TrainingPipeline";
            for (PipelineStepPair pipelineStepPair : pipelineStepPairs) {
                if (!pipelineStepPair.getStepArtifactId().equals(trainingModule)) continue;
                trainingPipeline = pipelineStepPair.getPipelineArtifactId();
            }
            vc.put("trainingPipelineSnakeCase", (Object)PythonGeneratorUtils.normalizeToPythonCase(trainingPipeline));
            this.generateFile(context, vc);
        }
    }
}

