/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.common;

import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.common.PipelineStepPair;
import com.boozallen.aiops.mda.generator.common.PipelineStrategy;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStrategy
implements PipelineStrategy {
    protected final List<Pipeline> pipelines;

    protected AbstractStrategy(List<Pipeline> pipelines, PipelineEnum pipelineType) {
        this.pipelines = this.getPipelinesByType(pipelines, pipelineType);
    }

    private List<Pipeline> getPipelinesByType(List<Pipeline> pipelines, PipelineEnum pipelineType) {
        ArrayList<Pipeline> pipelinesByType = new ArrayList<Pipeline>();
        if (pipelines != null) {
            for (Pipeline pipeline : pipelines) {
                if (!pipelineType.equalsIgnoreCase(pipeline.getType().getName())) continue;
                pipelinesByType.add(pipeline);
            }
        } else {
            throw new IllegalArgumentException("Attempting to read a null pipelines list");
        }
        return pipelinesByType;
    }

    @Override
    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    @Override
    public List<String> getArtifactIds() {
        ArrayList<String> pipelineArtifactIds = new ArrayList<String>();
        for (Pipeline pipeline : this.pipelines) {
            String pipelineName = pipeline.getName();
            String artifactId = PipelineUtils.deriveArtifactIdFromCamelCase(pipelineName);
            pipelineArtifactIds.add(artifactId);
        }
        return pipelineArtifactIds;
    }

    @Override
    public List<String> getStepArtifactIds() {
        ArrayList<String> stepArtifactIds = new ArrayList<String>();
        for (PipelineStepPair pair : this.getSteps()) {
            String pipelineStepName = pair.getStep().getName();
            String artifactId = PipelineUtils.deriveArtifactIdFromCamelCase(pipelineStepName);
            stepArtifactIds.add(artifactId);
        }
        return stepArtifactIds;
    }
}

