/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.common;

import com.boozallen.aiops.mda.generator.common.AbstractStrategy;
import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.common.PipelineImplementationEnum;
import com.boozallen.aiops.mda.generator.common.PipelineStepPair;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.BasePipelineDecorator;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPipeline;
import java.util.ArrayList;
import java.util.List;

public class DataFlowStrategy
extends AbstractStrategy {
    public DataFlowStrategy(List<Pipeline> pipelines) {
        super(pipelines, PipelineEnum.DATA_FLOW);
    }

    @Override
    public List<PipelineStepPair> getSteps() {
        ArrayList<PipelineStepPair> steps = new ArrayList<PipelineStepPair>();
        for (Pipeline pipeline : this.pipelines) {
            PythonPipeline pythonPipeline = new PythonPipeline(pipeline);
            for (Step step : pythonPipeline.getSteps()) {
                steps.add(new PipelineStepPair(pipeline, step));
            }
        }
        return steps;
    }

    public List<String> getSparkPipelines() {
        return this.getPipelinesByImplementation(PipelineImplementationEnum.DATA_DELIVERY_SPARK);
    }

    public boolean hasSparkPipelines() {
        return !this.getSparkPipelines().isEmpty();
    }

    public List<String> getPySparkPipelines() {
        return this.getPipelinesByImplementation(PipelineImplementationEnum.DATA_DELIVERY_PYSPARK);
    }

    public boolean hasPySparkPipelines() {
        return !this.getPySparkPipelines().isEmpty();
    }

    private List<String> getPipelinesByImplementation(PipelineImplementationEnum implementation) {
        ArrayList<String> pipelinesByImplementation = new ArrayList<String>();
        for (Pipeline pipeline : this.pipelines) {
            if (!implementation.equalsIgnoreCase(pipeline.getType().getImplementation())) continue;
            String artifactId = PipelineUtils.deriveArtifactIdFromCamelCase(pipeline.getName());
            pipelinesByImplementation.add(artifactId);
        }
        return pipelinesByImplementation;
    }

    public boolean isPySparkSupportNeeded() {
        return !this.getPySparkPipelines().isEmpty();
    }

    public boolean isDeltaSupportNeeded() {
        boolean deltaSupportNeeded = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isDeltaSupportNeeded()) continue;
            deltaSupportNeeded = true;
            break;
        }
        return deltaSupportNeeded;
    }

    public boolean isHiveSupportNeeded() {
        boolean hiveSupport = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isHiveSupportNeeded()) continue;
            hiveSupport = true;
            break;
        }
        return hiveSupport;
    }

    public boolean isPostgresSupportNeeded() {
        boolean postgresSupport = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isPostgresSupportNeeded()) continue;
            postgresSupport = true;
            break;
        }
        return postgresSupport;
    }

    public boolean isRdbmsSupportNeeded() {
        boolean postgresSupport = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isRdbmsSupportNeeded()) continue;
            postgresSupport = true;
            break;
        }
        return postgresSupport;
    }

    public boolean isElasticsearchSupportNeeded() {
        boolean elasticsearchSupport = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isElasticsearchSupportNeeded()) continue;
            elasticsearchSupport = true;
            break;
        }
        return elasticsearchSupport;
    }

    public boolean isNeo4jSupportNeeded() {
        boolean neo4jSupport = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isNeo4jSupportNeeded()) continue;
            neo4jSupport = true;
            break;
        }
        return neo4jSupport;
    }

    public boolean isSedonaSupportNeeded() {
        boolean sedonaSupport = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isSedonaSupportNeeded()) continue;
            sedonaSupport = true;
            break;
        }
        return sedonaSupport;
    }

    public boolean isMetadataNeeded() {
        boolean metadataNeeded = false;
        for (Pipeline pipeline : this.pipelines) {
            BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
            if (!pipelineDecorator.isMetadataNeeded()) continue;
            metadataNeeded = true;
            break;
        }
        return metadataNeeded;
    }

    public boolean isDataLineageNeeded() {
        return Pipeline.aPipelineExistsWhere(this.pipelines, Pipeline::getDataLineage);
    }

    public List<BasePipelineDecorator> getDataFlowPipelinesRequiringAirflow() {
        ArrayList<BasePipelineDecorator> decoratedPipelines = new ArrayList<BasePipelineDecorator>();
        for (Pipeline pipeline : PipelineUtils.getDataFlowPipelinesRequiringAirflow(this.pipelines)) {
            BasePipelineDecorator decoratedPipeline = new BasePipelineDecorator(pipeline);
            decoratedPipelines.add(decoratedPipeline);
        }
        return decoratedPipelines;
    }

    public boolean isAirflowNeeded() {
        return this.getDataFlowPipelinesRequiringAirflow() != null && this.getDataFlowPipelinesRequiringAirflow().size() > 0;
    }
}

