/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.common;

import com.boozallen.aiops.mda.generator.common.AbstractStrategy;
import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.common.PipelineStepPair;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.BasePipelineDecorator;
import com.boozallen.aiops.mda.metamodel.element.BaseStepDecorator;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.Versioning;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPipeline;
import java.util.ArrayList;
import java.util.List;

public class MachineLearningStrategy
extends AbstractStrategy {
    public MachineLearningStrategy(List<Pipeline> pipelines) {
        super(pipelines, PipelineEnum.MACHINE_LEARNING);
    }

    @Override
    public List<PipelineStepPair> getSteps() {
        return this.getStepsByType("training");
    }

    public List<PipelineStepPair> getInferenceSteps() {
        return this.getStepsByType("inference");
    }

    public List<String> getInferenceModules() {
        ArrayList<String> inferenceModules = new ArrayList<String>();
        for (PipelineStepPair pair : this.getInferenceSteps()) {
            String moduleName = pair.getStep().getName();
            String moduleArtifactId = PipelineUtils.deriveArtifactIdFromCamelCase(moduleName);
            inferenceModules.add(moduleArtifactId);
        }
        return inferenceModules;
    }

    public List<String> getTrainingModules() {
        ArrayList<String> trainingModules = new ArrayList<String>();
        for (PipelineStepPair pair : this.getSteps()) {
            String moduleName = pair.getStep().getName();
            String moduleArtifactId = PipelineUtils.deriveArtifactIdFromCamelCase(moduleName);
            trainingModules.add(moduleArtifactId);
        }
        return trainingModules;
    }

    public List<BasePipelineDecorator> getMachineLearningPipelinesRequiringAirflow() {
        ArrayList<BasePipelineDecorator> decoratedPipelines = new ArrayList<BasePipelineDecorator>();
        for (Pipeline pipeline : PipelineUtils.getMachineLearningPipelinesRequiringAirflow(this.pipelines)) {
            BasePipelineDecorator decoratedPipeline = new BasePipelineDecorator(pipeline);
            List<BaseStepDecorator> pipelineSteps = decoratedPipeline.getSteps();
            for (Step step : pipelineSteps) {
                if (!step.getType().equalsIgnoreCase("training")) continue;
                decoratedPipelines.add(decoratedPipeline);
            }
        }
        return decoratedPipelines;
    }

    public boolean isAirflowNeeded() {
        return this.getMachineLearningPipelinesRequiringAirflow() != null && this.getMachineLearningPipelinesRequiringAirflow().size() > 0;
    }

    public boolean isMlflowNeeded() {
        boolean mlflowSupportNeeded = this.hasInferenceOrTrainingPipelineStep();
        return mlflowSupportNeeded;
    }

    public boolean isModelTrainingApiNeeded() {
        boolean modelTrainingApiSupportNeeded = this.hasTrainingPipelineStep();
        return modelTrainingApiSupportNeeded;
    }

    public boolean isPostgresNeeded() {
        boolean postgresSupportNeeded = this.isMlflowNeeded();
        return postgresSupportNeeded;
    }

    private boolean hasTrainingPipelineStep() {
        boolean trainingPipelineStepFound = false;
        List<String> mlPipelines = this.getArtifactIds();
        if (!mlPipelines.isEmpty()) {
            block0: for (Pipeline pipeline : this.pipelines) {
                BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
                List<BaseStepDecorator> pipelineSteps = pipelineDecorator.getSteps();
                for (Step step : pipelineSteps) {
                    if (!step.getType().equalsIgnoreCase("training")) continue;
                    trainingPipelineStepFound = true;
                    continue block0;
                }
            }
        }
        return trainingPipelineStepFound;
    }

    private boolean hasInferenceOrTrainingPipelineStep() {
        boolean inferenceOrTrainingPipelineStepFound = false;
        List<String> mlPipelines = this.getArtifactIds();
        if (!mlPipelines.isEmpty()) {
            block0: for (Pipeline pipeline : this.pipelines) {
                BasePipelineDecorator pipelineDecorator = new BasePipelineDecorator(pipeline);
                List<BaseStepDecorator> pipelineSteps = pipelineDecorator.getSteps();
                for (Step step : pipelineSteps) {
                    if (!step.getType().equalsIgnoreCase("inference") && !step.getType().equalsIgnoreCase("training")) continue;
                    inferenceOrTrainingPipelineStepFound = true;
                    continue block0;
                }
            }
        }
        return inferenceOrTrainingPipelineStepFound;
    }

    public boolean isVersioningSupportNeeded() {
        boolean enabled = false;
        for (Pipeline pipeline : this.getPipelines()) {
            Versioning versioning = pipeline.getType().getVersioning();
            if (versioning == null || !versioning.isEnabled().booleanValue()) continue;
            enabled = true;
            break;
        }
        return enabled;
    }

    public boolean isPostgresSupportNeeded() {
        return this.isMlflowNeeded();
    }

    public boolean isRdbmsSupportNeeded() {
        return this.isMlflowNeeded();
    }

    private List<PipelineStepPair> getStepsByType(String type) {
        ArrayList<PipelineStepPair> steps = new ArrayList<PipelineStepPair>();
        for (Pipeline pipeline : this.pipelines) {
            PythonPipeline pythonPipeline = new PythonPipeline(pipeline);
            for (Step step : pythonPipeline.getSteps()) {
                if (!type.equals(step.getType())) continue;
                steps.add(new PipelineStepPair(pipeline, step));
            }
        }
        return steps;
    }
}

