/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.common;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PipelineEnum {
    DATA_FLOW("data-flow"),
    MACHINE_LEARNING("machine-learning");

    private String pipelineType;

    private PipelineEnum(String pipelineType) {
        this.pipelineType = pipelineType;
    }

    public boolean equalsIgnoreCase(String compareType) {
        return this.pipelineType.equalsIgnoreCase(compareType);
    }

    public static boolean isValidType(String implementation) {
        PipelineEnum[] vals;
        for (PipelineEnum enumeration : vals = PipelineEnum.values()) {
            if (!enumeration.equalsIgnoreCase(implementation)) continue;
            return true;
        }
        return false;
    }

    public static String getPossibleValues() {
        return Stream.of(PipelineEnum.values()).map(type -> type.pipelineType).collect(Collectors.joining(", ", "[", "]"));
    }

    public static String getPipelineType(PipelineEnum pipelineEnum) {
        return pipelineEnum.pipelineType;
    }
}

