/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.common;

import com.boozallen.aiops.mda.generator.common.PipelineImplementationEnum;
import java.util.Arrays;
import java.util.List;

public enum PipelinePlatformEnum {
    SEDONA("sedona", PipelineImplementationEnum.DATA_DELIVERY_PYSPARK, PipelineImplementationEnum.DATA_DELIVERY_SPARK);

    private String platformName;
    private List<PipelineImplementationEnum> pipelineImplementations;

    private PipelinePlatformEnum(String platformName, PipelineImplementationEnum ... pipelineImplementations) {
        this.platformName = platformName;
        this.pipelineImplementations = Arrays.asList(pipelineImplementations);
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public List<PipelineImplementationEnum> getPipelineImplementations() {
        return this.pipelineImplementations;
    }

    public static boolean isValidPipelinePlatform(String platformName, String pipelineImplementation) {
        boolean isValid = false;
        for (PipelinePlatformEnum platform : PipelinePlatformEnum.values()) {
            if (!platform.getPlatformName().equalsIgnoreCase(platformName) || !platform.isValidPipelineImplementation(pipelineImplementation)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    private boolean isValidPipelineImplementation(String implementationToCheck) {
        boolean isValid = false;
        for (PipelineImplementationEnum implementation : this.getPipelineImplementations()) {
            if (!implementation.equalsIgnoreCase(implementationToCheck)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }
}

