/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.dictionary;

import com.boozallen.aiops.mda.generator.AbstractJavaGenerator;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Dictionary;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.java.JavaDictionaryType;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class JavaDictionaryTypeGenerator
extends AbstractJavaGenerator {
    @Override
    public void generate(GenerationContext generationContext) {
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Dictionary> dictionaryMap = metamodelRepository.getDictionariesByContext(this.metadataContext);
        String baseOutputFile = generationContext.getOutputFile();
        for (Dictionary dictionary : dictionaryMap.values()) {
            dictionary.validate();
            String dictionaryPackage = dictionary.getPackage();
            vc.put("basePackage", (Object)dictionaryPackage);
            vc.put("dictionary", (Object)dictionary);
            for (DictionaryType dictionaryType : dictionary.getDictionaryTypes()) {
                JavaDictionaryType javaDictionaryType = new JavaDictionaryType(dictionaryType);
                if (!javaDictionaryType.isComplex()) continue;
                javaDictionaryType.validate();
                vc.put("dictionaryType", (Object)javaDictionaryType);
                String dictionaryTypeOutputFile = this.getOutputFileName(javaDictionaryType, dictionaryPackage, baseOutputFile);
                generationContext.setOutputFile(dictionaryTypeOutputFile);
                this.generateFile(generationContext, vc);
            }
        }
    }

    private String getOutputFileName(JavaDictionaryType dictionaryType, String dictionaryPackage, String baseOutputFile) {
        String basePackagePath = dictionaryPackage.replace(".", "/");
        String fileName = this.replaceBasePackage(baseOutputFile, basePackagePath);
        return this.replace("dictionaryTypeName", fileName, dictionaryType.getCapitalizedName());
    }
}

