/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.post.action;

import com.boozallen.aiops.mda.generator.AbstractPythonGenerator;
import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.post.action.ModelConversionType;
import com.boozallen.aiops.mda.generator.post.action.PostActionType;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.PostAction;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.python.MachineLearningPipeline;
import com.boozallen.aiops.mda.metamodel.element.training.ModelConversionPostAction;
import com.boozallen.aiops.mda.metamodel.element.training.OnnxModelConversionPostAction;
import com.boozallen.aiops.mda.metamodel.element.util.PythonElementUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public class PostActionGenerator
extends AbstractPythonGenerator {
    public void generate(GenerationContext context) {
        Pipeline targetPipeline = PipelineUtils.getTargetedPipeline(context, this.metadataContext);
        if (this.hasPostActions(targetPipeline)) {
            MachineLearningPipeline mlPipeline = new MachineLearningPipeline(targetPipeline);
            Step trainingStep = mlPipeline.getTrainingStep();
            String baseOutputFile = context.getOutputFile();
            for (PostAction postAction : trainingStep.getPostActions()) {
                if (!this.shouldGenerateFile(postAction)) continue;
                VelocityContext vc = this.getNewVelocityContext(context);
                PostAction postActionDecorator = this.getPostActionDecorator(postAction);
                vc.put("postAction", (Object)postActionDecorator);
                String outputFileName = this.getOutputFileName(baseOutputFile, postActionDecorator);
                context.setOutputFile(outputFileName);
                this.generateFile(context, vc);
            }
        }
    }

    protected boolean shouldGenerateFile(PostAction postAction) {
        return true;
    }

    protected String getOutputFileName(String baseOutputFile, PostAction postAction) {
        String snakeCaseName = PythonElementUtils.getSnakeCaseValue(postAction.getName());
        return this.replace("postActionName", baseOutputFile, snakeCaseName);
    }

    private boolean hasPostActions(Pipeline pipeline) {
        boolean hasPostActions = false;
        String pipelineType = pipeline.getType().getName();
        if (PipelineEnum.MACHINE_LEARNING.equalsIgnoreCase(pipelineType)) {
            MachineLearningPipeline mlPipeline = new MachineLearningPipeline(pipeline);
            Step trainingStep = mlPipeline.getTrainingStep();
            hasPostActions = trainingStep != null && CollectionUtils.isNotEmpty(trainingStep.getPostActions());
        }
        return hasPostActions;
    }

    private PostAction getPostActionDecorator(PostAction postAction) {
        PostActionType postActionType = PostActionType.getPostActionType(postAction);
        return switch (postActionType) {
            case PostActionType.MODEL_CONVERSION -> this.getModelConversionPostActionDecorator(postAction);
            default -> postAction;
        };
    }

    private PostAction getModelConversionPostActionDecorator(PostAction postAction) {
        ModelConversionType modelConversionType = ModelConversionType.getModelConversionType(postAction);
        return switch (modelConversionType) {
            case ModelConversionType.ONNX -> new OnnxModelConversionPostAction(postAction);
            default -> new ModelConversionPostAction(postAction);
        };
    }
}

