/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.record;

import com.boozallen.aiops.mda.generator.AbstractPythonGenerator;
import com.boozallen.aiops.mda.generator.common.FrameworkEnum;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Framework;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.pyspark.PySparkRecord;
import com.boozallen.aiops.mda.metamodel.element.python.PythonRecord;
import java.util.Map;
import java.util.Optional;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class PythonRecordGenerator
extends AbstractPythonGenerator {
    public void generate(GenerationContext generationContext) {
        VelocityContext vc = this.getNewVelocityContext(generationContext);
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Record> recordMap = metamodelRepository.getRecordsByContext(this.metadataContext);
        String baseOutputFile = generationContext.getOutputFile();
        for (Record currentRecord : recordMap.values()) {
            PythonRecord pythonRecord = this.getPythonRecord(currentRecord);
            vc.put("record", (Object)pythonRecord);
            String recordOutputFileName = this.replace("recordName", baseOutputFile, pythonRecord.getSnakeCaseName());
            generationContext.setOutputFile(recordOutputFileName);
            this.generateFile(generationContext, vc);
        }
    }

    protected PythonRecord getPythonRecord(Record currentRecord) {
        Optional<Framework> frameworkOptional = currentRecord.getFrameworks().stream().filter(framework -> FrameworkEnum.PYSPARK.equals((Object)framework.getName())).findAny();
        if (frameworkOptional.isPresent()) {
            return new PySparkRecord(currentRecord);
        }
        return new PythonRecord(currentRecord);
    }
}

