/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.util;

import com.boozallen.aiops.mda.generator.util.SemanticDataUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenUtil {
    private static final Logger logger = LoggerFactory.getLogger(MavenUtil.class);

    public static boolean fileExists(File directory, String name) {
        File[] files = directory.listFiles();
        if (files != null) {
            return Arrays.stream(files).anyMatch(file -> file.getName().equals(name));
        }
        return false;
    }

    public static boolean isMavenDir(File directory) {
        return MavenUtil.fileExists(directory, "pom.xml");
    }

    @Deprecated
    public static Optional<File> findRootProjectDirectory(File directory) {
        Optional<File> result;
        File[] files = directory.listFiles();
        File parent = directory.getParentFile();
        if (files == null) {
            if (parent == null) {
                return Optional.empty();
            }
            result = MavenUtil.findRootProjectDirectory(parent);
        } else if (MavenUtil.isMavenDir(parent)) {
            result = MavenUtil.findRootProjectDirectory(parent);
            if (!result.isPresent()) {
                return Optional.of(directory);
            }
        } else {
            result = MavenUtil.isMavenDir(directory) ? Optional.of(directory) : Optional.empty();
        }
        return result;
    }

    public static String getPipelineModelModuleName(File rootProjectDirectory) {
        return MavenUtil.getChildModuleName(rootProjectDirectory, ".+-pipeline-models");
    }

    public static String getDeployModuleName(File rootProjectDirectory) {
        return MavenUtil.getChildModuleName(rootProjectDirectory, ".+-deploy");
    }

    public static String getDockerModuleName(File rootProjectDirectory) {
        return MavenUtil.getChildModuleName(rootProjectDirectory, ".+-docker");
    }

    public static String getSharedModuleName(File rootProjectDirectory) {
        return MavenUtil.getChildModuleName(rootProjectDirectory, ".+-shared");
    }

    public static String getDataRecordModuleName(GenerationContext context, String metadataContext, Language language, SemanticDataUtil.DataRecordModule dataModule) {
        String projectPrefix = context.getRootArtifactId();
        String defaultDataRecords = projectPrefix + "-" + dataModule.getBaseName();
        Path projectRoot = context.getExecutionRootDirectory().toPath();
        Path defaultModulePath = MavenUtil.getSharedModuleName(context.getExecutionRootDirectory()) != null ? projectRoot.resolve(Path.of(MavenUtil.getSharedModuleName(context.getExecutionRootDirectory()), defaultDataRecords)) : projectRoot.resolve(Path.of(defaultDataRecords, new String[0]));
        Language defaultLanguage = MavenUtil.getModuleLanguage(defaultModulePath.resolve("pom.xml"));
        if (SemanticDataUtil.arePythonDataRecordsNeeded(metadataContext) && SemanticDataUtil.areJavaDataRecordsNeeded(metadataContext) && !language.equals((Object)defaultLanguage)) {
            return defaultDataRecords + "-" + language.getLanguageName();
        }
        return defaultDataRecords;
    }

    public static String getChildModuleName(File rootDirectory, String childRegex) {
        File pomFile = new File(rootDirectory.getPath() + File.separator + "pom.xml");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pomFile);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("module");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                String field;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(field = (element = (Element)node).getTextContent()).matches(childRegex)) continue;
                return field;
            }
        }
        catch (Exception e) {
            logger.error("Unable to find deploy-module", (Throwable)e);
            throw new NoSuchElementException("No deploy module identified within " + pomFile.getPath());
        }
        return null;
    }

    public static Language getModuleLanguage(Path pomFile) {
        Language language = Language.UNKNOWN;
        if (Files.exists(pomFile, new LinkOption[0])) {
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                Model model = reader.read((Reader)Files.newBufferedReader(pomFile));
                String existingPackaging = model.getPackaging();
                for (Language lang : Language.values()) {
                    if (!existingPackaging.equals(lang.getPackaging())) continue;
                    language = lang;
                    break;
                }
            }
            catch (IOException | XmlPullParserException e) {
                throw new RuntimeException("Failed to read existing data record module to detect language", e);
            }
        }
        return language;
    }

    public static String getPySparkDataDeliveryProfileName(GenerationContext context) {
        File pomFile = new File(context.getProjectDirectory() + File.separator + "pom.xml");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(pomFile);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getElementsByTagName("profile");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                String field;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(field = (element = (Element)node).getTextContent()).equals("data-delivery-pyspark") && !field.equals("data-delivery-pyspark-pipeline")) continue;
                return field;
            }
        }
        catch (Exception e) {
            logger.error("Unable to find profileName", (Throwable)e);
            throw new NoSuchElementException("No profile name identified within " + pomFile.getPath());
        }
        return null;
    }

    public static enum Language {
        JAVA("java", "jar"),
        PYTHON("python", "habushu"),
        UNKNOWN("unknown", null);

        private final String languageName;
        private final String packaging;

        private Language(String languageName, String packaging) {
            this.languageName = languageName;
            this.packaging = packaging;
        }

        public String getLanguageName() {
            return this.languageName;
        }

        public String getPackaging() {
            return this.packaging;
        }
    }
}

