/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.util;

import com.boozallen.aiops.mda.generator.common.DataFlowStrategy;
import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.post.action.ModelConversionType;
import com.boozallen.aiops.mda.generator.post.action.PostActionType;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.PostAction;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public final class PipelineUtils {
    private static final String TARGET_PIPELINE = "targetPipeline";
    protected static final String AISSEMBLE_VERSION = "aissembleVersion";
    private static final Logger logger = LoggerFactory.getLogger(PipelineUtils.class);

    private PipelineUtils() {
    }

    public static Pipeline getTargetedPipeline(GenerationContext generationContext, String metadataContext) {
        Map generationPropertyVariables = generationContext.getPropertyVariables();
        String targetPipelineName = (String)generationPropertyVariables.get(TARGET_PIPELINE);
        PipelineUtils.assertTargetPipelineConfigurationFound(targetPipelineName);
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(metadataContext);
        Pipeline targetPipeline = pipelineMap.get(targetPipelineName);
        PipelineUtils.assertTargetPipelineExists(targetPipelineName, targetPipeline);
        return targetPipeline;
    }

    public static String getQualifiedPipelineStepName(Pipeline pipeline, Step step) {
        return pipeline.getName() + "." + step.getName();
    }

    private static void assertTargetPipelineConfigurationFound(String targetedPipelineName) {
        if (StringUtils.isBlank((CharSequence)targetedPipelineName)) {
            StringBuilder sb = new StringBuilder();
            sb.append("\n<plugin>\n");
            sb.append("\t<groupId>org.technologybrewery.fermenter</groupId>\n");
            sb.append("\t<artifactId>fermenter-mda</artifactId>\n");
            sb.append("\t...\n");
            sb.append("\t<configuration>\n");
            sb.append("\t\t<propertyVariables>\n");
            sb.append("\t\t\t<").append(TARGET_PIPELINE).append(">PIPELINE NAME HERE</").append(TARGET_PIPELINE).append(">   <-----------  MISSING VALUE!\n");
            sb.append("\t\t</propertyVariables>\n");
            sb.append("\t\t...\n");
            sb.append("\t</configuration>\n");
            sb.append("</plugin>\n");
            String errorMessage = sb.toString();
            logger.error(errorMessage);
            throw new GenerationException("A targetedPipeline value MUST be provided!");
        }
    }

    private static void assertTargetPipelineExists(String targetedPipelineName, Pipeline targetedPipeline) {
        if (targetedPipeline == null) {
            throw new GenerationException("Target pipeline '" + targetedPipelineName + "' could not be found!");
        }
    }

    public static boolean isAsynchronousStep(Step step) {
        return "asynchronous".equals(step.getType());
    }

    public static boolean isSynchronousStep(Step step) {
        return "synchronous".equalsIgnoreCase(step.getType());
    }

    public static boolean isGenericStep(Step step) {
        return "generic".equalsIgnoreCase(step.getType());
    }

    public static String deriveArtifactIdFromCamelCase(String camelCasedString) {
        String acronymCleanString = PipelineUtils.normalizeAcronyms(camelCasedString);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, acronymCleanString);
    }

    public static String deriveLowercaseSnakeCaseNameFromCamelCase(String camelCasedString) {
        String acronymCleanString = PipelineUtils.normalizeAcronyms(camelCasedString);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, acronymCleanString);
    }

    public static String deriveLowerSnakeCaseNameFromHyphenatedString(String hyphenatedString) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, hyphenatedString);
    }

    public static String deriveLowerCamelNameFromUpperCamelName(String camelCasedString) {
        String acronymCleanString = PipelineUtils.normalizeAcronyms(camelCasedString);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, acronymCleanString);
    }

    public static String deriveUpperUnderscoreNameFromUpperCamelName(String camelCasedString) {
        String acronymCleanString = PipelineUtils.normalizeAcronyms(camelCasedString);
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, acronymCleanString);
    }

    public static String deriveUpperCamelNameFromLowerUnderscoreName(String lowerUnderscoreString) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, lowerUnderscoreString);
    }

    public static String getAiSSEMBLEVersion(GenerationContext generationContext) {
        return (String)generationContext.getPropertyVariables().get(AISSEMBLE_VERSION);
    }

    public static List<Pipeline> getDataFlowPipelinesRequiringAirflow(List<Pipeline> pipelines) {
        ArrayList<Pipeline> airflowPipelines = new ArrayList<Pipeline>();
        for (Pipeline pipeline : pipelines) {
            if (!pipeline.requiresAirflow() || !PipelineEnum.DATA_FLOW.equalsIgnoreCase(pipeline.getType().getName())) continue;
            airflowPipelines.add(pipeline);
        }
        return airflowPipelines;
    }

    public static List<Pipeline> getMachineLearningPipelinesRequiringAirflow(List<Pipeline> pipelines) {
        ArrayList<Pipeline> airflowPipelines = new ArrayList<Pipeline>();
        for (Pipeline pipeline : pipelines) {
            if (!pipeline.requiresAirflow() || !PipelineEnum.MACHINE_LEARNING.equalsIgnoreCase(pipeline.getType().getName())) continue;
            airflowPipelines.add(pipeline);
        }
        return airflowPipelines;
    }

    public static List<Pipeline> getPipelines(String metadataContext) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Pipeline> pipelineMap = metamodelRepository.getPipelinesByContext(metadataContext);
        return new ArrayList<Pipeline>(pipelineMap.values());
    }

    public static DataFlowStrategy getDataFlowPipelines(String metadataContext) {
        return new DataFlowStrategy(PipelineUtils.getPipelines(metadataContext));
    }

    private static String normalizeAcronyms(String camelCasedString) {
        String[] splitStrings;
        StringBuilder normalizedString = new StringBuilder();
        for (String segment : splitStrings = StringUtils.splitByCharacterTypeCamelCase((String)camelCasedString)) {
            normalizedString.append(StringUtils.capitalize((String)StringUtils.lowerCase((String)segment)));
        }
        return normalizedString.toString();
    }

    public static boolean forOnnxModelConversion(PostAction postAction) {
        ModelConversionType modelConversionType;
        boolean forOnnxModelConversion = false;
        PostActionType postActionType = PostActionType.getPostActionType(postAction);
        if (postActionType == PostActionType.MODEL_CONVERSION && (modelConversionType = ModelConversionType.getModelConversionType(postAction)) == ModelConversionType.ONNX) {
            forOnnxModelConversion = true;
        }
        return forOnnxModelConversion;
    }
}

