/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.util;

import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.technologybrewery.fermenter.mda.generator.GenerationContext;

public final class PythonGeneratorUtils {
    private PythonGeneratorUtils() {
    }

    public static VelocityContext populateCommonPythonContext(VelocityContext velocityContext, GenerationContext generationContext) {
        if (velocityContext == null) {
            velocityContext = new VelocityContext();
        }
        velocityContext.put("packageName", (Object)generationContext.getArtifactId());
        velocityContext.put("packageFolderName", (Object)generationContext.getBasePackage());
        return velocityContext;
    }

    public static String normalizeToPythonCase(String value) {
        return PipelineUtils.deriveLowerSnakeCaseNameFromHyphenatedString(value);
    }

    public static String getPythonDependencyVersion(String mavenVersion) {
        Object pythonVersion = mavenVersion;
        if (StringUtils.isNotEmpty((CharSequence)mavenVersion) && mavenVersion.endsWith("-SNAPSHOT")) {
            pythonVersion = StringUtils.substringBeforeLast((String)mavenVersion, (String)"-SNAPSHOT") + ".*";
        }
        return pythonVersion;
    }
}

