/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.generator.util;

import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.Dictionary;
import com.boozallen.aiops.mda.metamodel.element.Record;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class SemanticDataUtil {
    public static boolean hasSemanticDataByContext(String metadataContext) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Dictionary> dictionaryMap = metamodelRepository.getDictionariesByContext(metadataContext);
        Map<String, Record> recordMap = metamodelRepository.getRecordsByContext(metadataContext);
        return !dictionaryMap.isEmpty() || !recordMap.isEmpty();
    }

    public static boolean hasSemanticDataByArtifactId(String artifactId) {
        AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));
        Map<String, Dictionary> dictionaryMap = metamodelRepository.getDictionariesByArtifactId(artifactId);
        Map<String, Record> recordMap = metamodelRepository.getRecordsByArtifactId(artifactId);
        return !MapUtils.isEmpty(dictionaryMap) || !MapUtils.isEmpty(recordMap);
    }

    public static boolean arePythonDataRecordsNeeded(String metadataContext) {
        return SemanticDataUtil.hasSemanticDataByContext(metadataContext) && PipelineUtils.getDataFlowPipelines(metadataContext).hasPySparkPipelines();
    }

    public static boolean areJavaDataRecordsNeeded(String metadataContext) {
        return SemanticDataUtil.hasSemanticDataByContext(metadataContext) && PipelineUtils.getDataFlowPipelines(metadataContext).hasSparkPipelines();
    }

    public static enum DataRecordModule {
        COMBINED("data-records"),
        CORE("data-records-core"),
        SPARK("data-records-spark");

        private final String baseName;

        private DataRecordModule(String baseName) {
            this.baseName = baseName;
        }

        public String getBaseName() {
            return this.baseName;
        }
    }
}

