/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel;

import com.boozallen.aiops.mda.generator.config.deployment.DeploymentConfigurationManager;
import com.boozallen.aiops.mda.metamodel.CompositeModelInstanceManager;
import com.boozallen.aiops.mda.metamodel.DictionaryModelInstanceManager;
import com.boozallen.aiops.mda.metamodel.LoggerDelegateImpl;
import com.boozallen.aiops.mda.metamodel.PipelineModelInstanceManager;
import com.boozallen.aiops.mda.metamodel.RecordModelInstanceManager;
import com.boozallen.aiops.mda.metamodel.element.Composite;
import com.boozallen.aiops.mda.metamodel.element.Dictionary;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.json.AiopsMdaJsonUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.GenerateSourcesHelper;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.AbstractModelInstanceRepository;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceUrl;
import org.technologybrewery.fermenter.mda.metamodel.ModelRepositoryConfiguration;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

public class AIOpsModelInstanceRepostory
extends AbstractModelInstanceRepository {
    private static final String DEPLOYMENT_CONFIG_FILE_NAME = "deployment-config.json";
    private static final Logger logger = LoggerFactory.getLogger(AIOpsModelInstanceRepostory.class);
    private DictionaryModelInstanceManager dictionaryManager = DictionaryModelInstanceManager.getInstance();
    private CompositeModelInstanceManager compositeManager = CompositeModelInstanceManager.getInstance();
    private RecordModelInstanceManager recordManager = RecordModelInstanceManager.getInstance();
    private PipelineModelInstanceManager pipelineManager = PipelineModelInstanceManager.getInstance();
    private DeploymentConfigurationManager deploymentConfigurationManager;

    public AIOpsModelInstanceRepostory(ModelRepositoryConfiguration config) {
        super(config);
        AiopsMdaJsonUtils.configureCustomObjectMappper();
    }

    public void load() {
        this.pipelineManager.reset();
        this.recordManager.reset();
        this.compositeManager.reset();
        this.dictionaryManager.reset();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            this.deploymentConfigurationManager = (DeploymentConfigurationManager)objectMapper.readValue(new File(DEPLOYMENT_CONFIG_FILE_NAME), DeploymentConfigurationManager.class);
        }
        catch (IOException e) {
            logger.warn("deployment-config.json was not found.  Proceeding with defaults--");
            this.deploymentConfigurationManager = new DeploymentConfigurationManager();
        }
        Collection modelInstanceUrls = this.config.getMetamodelInstanceLocations().values();
        for (ModelInstanceUrl modelInstanceUrl : modelInstanceUrls) {
            long start = System.currentTimeMillis();
            this.dictionaryManager.loadMetadata(modelInstanceUrl, this.config);
            this.compositeManager.loadMetadata(modelInstanceUrl, this.config);
            this.recordManager.loadMetadata(modelInstanceUrl, this.config);
            this.pipelineManager.loadMetadata(modelInstanceUrl, this.config);
            if (!logger.isInfoEnabled()) continue;
            long stop = System.currentTimeMillis();
            logger.info("Metamodel instances for artifactId '{}' have been loaded - {}ms", (Object)modelInstanceUrl.getArtifactId(), (Object)(stop - start));
        }
    }

    public void validate() {
        for (Dictionary dictionary : this.dictionaryManager.getMetadataElementWithoutPackage().values()) {
            dictionary.validate();
        }
        for (Composite composite : this.compositeManager.getMetadataElementWithoutPackage().values()) {
            composite.validate();
        }
        for (Record recordInstance : this.recordManager.getMetadataElementWithoutPackage().values()) {
            recordInstance.validate();
        }
        for (Pipeline pipeline : this.pipelineManager.getMetadataElementWithoutPackage().values()) {
            pipeline.validate();
        }
        MessageTracker messageTracker = MessageTracker.getInstance();
        LoggerDelegateImpl loggerDelegate = new LoggerDelegateImpl();
        messageTracker.emitMessages((GenerateSourcesHelper.LoggerDelegate)loggerDelegate);
        if (messageTracker.hasErrors()) {
            throw new GenerationException("Encountered one or more errors!  Please check your Maven output for details.");
        }
    }

    public Pipeline getPipeline(String name) {
        return (Pipeline)this.pipelineManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Pipeline getPipeline(String packageName, String name) {
        return (Pipeline)this.pipelineManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Pipeline> getPipelines(String packageName) {
        return this.pipelineManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Pipeline> getPipelinesByArtifactId(String artifactId) {
        return this.pipelineManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Pipeline> getPipelinesByContext(String context) {
        return this.pipelineManager.getMetadataElementByContext(context);
    }

    public Record getRecord(String name) {
        return (Record)this.recordManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Record getRecord(String packageName, String name) {
        return (Record)this.recordManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Record> getRecords(String packageName) {
        return this.recordManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Record> getRecordsByArtifactId(String artifactId) {
        return this.recordManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Record> getRecordsByContext(String context) {
        return this.recordManager.getMetadataElementByContext(context);
    }

    public Composite getComposite(String name) {
        return (Composite)this.compositeManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Composite getComposite(String packageName, String name) {
        return (Composite)this.compositeManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public Map<String, Composite> getComposites(String packageName) {
        return this.compositeManager.getMetadataElementByPackage(packageName);
    }

    public Map<String, Composite> getCompositesByArtifactId(String artifactId) {
        return this.compositeManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Composite> getCompositesByContext(String context) {
        return this.compositeManager.getMetadataElementByContext(context);
    }

    public Dictionary getDictionary(String name) {
        return (Dictionary)this.dictionaryManager.getMetadataElementByPackageAndName(this.config.getBasePackage(), name);
    }

    public Map<String, Dictionary> getDictionariesByArtifactId(String artifactId) {
        return this.dictionaryManager.getMetadataByArtifactIdMap(artifactId);
    }

    public Map<String, Dictionary> getDictionariesByContext(String context) {
        return this.dictionaryManager.getMetadataElementByContext(context);
    }

    public Dictionary getDictionary(String packageName, String name) {
        return (Dictionary)this.dictionaryManager.getMetadataElementByPackageAndName(packageName, name);
    }

    public DictionaryType getDictionaryType(String name) {
        return this.getDictionaryType(this.config.getBasePackage(), name);
    }

    public DictionaryType getDictionaryType(String packageName, String name) {
        String fullyQualifiedName = packageName + "." + name;
        Map<String, DictionaryType> dictionaryTypes = this.dictionaryManager.getDictionaryTypesByFullyQualifiedName();
        return dictionaryTypes.get(fullyQualifiedName);
    }

    public DeploymentConfigurationManager getDeploymentConfigurationManager() {
        return this.deploymentConfigurationManager;
    }
}

