/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel;

import com.boozallen.aiops.mda.metamodel.element.Dictionary;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import java.util.HashMap;
import java.util.Map;
import org.technologybrewery.fermenter.mda.metamodel.AbstractMetamodelManager;

class DictionaryModelInstanceManager
extends AbstractMetamodelManager<Dictionary> {
    private static final DictionaryModelInstanceManager instance = new DictionaryModelInstanceManager();
    private Map<String, DictionaryType> dictionaryTypesByFullyQualifiedName = new HashMap<String, DictionaryType>();

    public static DictionaryModelInstanceManager getInstance() {
        return instance;
    }

    private DictionaryModelInstanceManager() {
    }

    protected String getMetadataLocation() {
        return "dictionaries";
    }

    protected Class<Dictionary> getMetamodelClass() {
        return Dictionary.class;
    }

    protected String getMetamodelDescription() {
        return Dictionary.class.getSimpleName();
    }

    protected void postLoadMetamodel() {
        for (Dictionary dictionary : this.getMetadataElementWithoutPackage().values()) {
            String dictionaryPackage = dictionary.getPackage();
            for (DictionaryType dictionaryType : dictionary.getDictionaryTypes()) {
                String fullyQualifiedName = dictionaryPackage + "." + dictionaryType.getName();
                this.dictionaryTypesByFullyQualifiedName.put(fullyQualifiedName, dictionaryType);
            }
        }
        super.postLoadMetamodel();
    }

    public Map<String, DictionaryType> getDictionaryTypesByFullyQualifiedName() {
        return this.dictionaryTypesByFullyQualifiedName;
    }
}

