/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.Validation;
import com.boozallen.aiops.mda.metamodel.element.ValidationElement;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.TypeManager;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelUtils;

public class BaseDictionaryTypeDecorator
implements DictionaryType {
    protected DictionaryType wrapped;

    public BaseDictionaryTypeDecorator(DictionaryType dictionaryTypeToDecorate) {
        MetamodelUtils.validateWrappedInstanceIsNonNull(this.getClass(), (Object)dictionaryTypeToDecorate);
        this.wrapped = dictionaryTypeToDecorate;
    }

    public String getPackage() {
        return this.wrapped.getPackage();
    }

    public String getFileName() {
        return this.wrapped.getFileName();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void validate() {
        this.wrapped.validate();
    }

    @Override
    public String getSimpleType() {
        return this.wrapped.getSimpleType();
    }

    @Override
    public Validation getValidation() {
        return this.wrapped.getValidation();
    }

    @Override
    public String getProtectionPolicy() {
        return this.wrapped.getProtectionPolicy();
    }

    @Override
    public String getEthicsPolicy() {
        return this.wrapped.getEthicsPolicy();
    }

    @Override
    public String getDriftPolicy() {
        return this.wrapped.getDriftPolicy();
    }

    @Override
    public String getSecurityPolicy() {
        return this.wrapped.getSecurityPolicy();
    }

    protected void validateValidations(List<String> validatableTypes, boolean isString, boolean isDecimal) {
        if (this.hasValidationConstraints() && !validatableTypes.contains(this.getShortType())) {
            throw new GenerationException("Dictionary type '" + this.getName() + "' has validation but is not a validatable type. Please remove the validation for this type.");
        }
        if (this.hasLengthValidation() && !isString) {
            throw new GenerationException("Dictionary type '" + this.getName() + "' has length validation but is not a string type. Please remove any min/max length validation for this type.");
        }
        if (this.hasFormatValidation() && !isString) {
            throw new GenerationException("Dictionary type '" + this.getName() + "' has format validation but is not a string type. Please remove the format validation for this type.");
        }
        if (this.hasValueValidation() && isString) {
            throw new GenerationException("Dictionary type '" + this.getName() + "' has value validation but is not a numeric type. Please remove any min/max value validation for this type.");
        }
        if (this.hasScaleValidation() && !isDecimal) {
            throw new GenerationException("Dictionary type '" + this.getName() + "' has scale validation but is not a decimal type. Please remove the scale validation for this type.");
        }
    }

    public String getCapitalizedName() {
        return StringUtils.capitalize((String)this.getName());
    }

    public String getFullyQualifiedType() {
        return TypeManager.getFullyQualifiedType((String)this.getSimpleType());
    }

    public String getShortType() {
        return TypeManager.getShortType((String)this.getSimpleType());
    }

    public boolean hasValidationConstraints() {
        ValidationElement validation = (ValidationElement)this.getValidation();
        return validation != null && validation.hasValidationContraints();
    }

    public boolean isComplex() {
        boolean hasDriftPolicy = StringUtils.isNotBlank((CharSequence)this.getDriftPolicy());
        boolean hasEthicsPolicy = StringUtils.isNotBlank((CharSequence)this.getEthicsPolicy());
        boolean hasProtectionPolicy = StringUtils.isNotBlank((CharSequence)this.getProtectionPolicy());
        return this.hasValidationConstraints() || hasDriftPolicy || hasEthicsPolicy || hasProtectionPolicy;
    }

    public boolean hasLengthValidation() {
        Validation validation = this.getValidation();
        return validation != null && (validation.getMaxLength() != null || validation.getMinLength() != null);
    }

    public boolean hasValueValidation() {
        Validation validation = this.getValidation();
        return validation != null && (validation.getMaxValue() != null || validation.getMinValue() != null);
    }

    public boolean hasScaleValidation() {
        Validation validation = this.getValidation();
        return validation != null && validation.getScale() != null;
    }

    public boolean hasFormatValidation() {
        Validation validation = this.getValidation();
        return validation != null && CollectionUtils.isNotEmpty(validation.getFormats());
    }
}

