/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.common.PersistType;
import com.boozallen.aiops.mda.generator.common.PipelineExecuterHelperEnum;
import com.boozallen.aiops.mda.generator.common.PipelinePlatformEnum;
import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.BaseFileStoreDecorator;
import com.boozallen.aiops.mda.metamodel.element.BasePipelineTypeDecorator;
import com.boozallen.aiops.mda.metamodel.element.BaseStepDecorator;
import com.boozallen.aiops.mda.metamodel.element.FileStore;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.PipelineType;
import com.boozallen.aiops.mda.metamodel.element.Platform;
import com.boozallen.aiops.mda.metamodel.element.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.shared.utils.StringUtils;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.element.Metamodel;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelUtils;

public class BasePipelineDecorator
implements Pipeline {
    protected Pipeline wrapped;

    public BasePipelineDecorator(Pipeline pipelineToDecorate) {
        MetamodelUtils.validateWrappedInstanceIsNonNull(this.getClass(), (Object)pipelineToDecorate);
        this.wrapped = pipelineToDecorate;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public String deriveArtifactIdFromCamelCase() {
        return PipelineUtils.deriveArtifactIdFromCamelCase(this.wrapped.getName());
    }

    public String deriveLowercaseSnakeCaseNameFromCamelCase() {
        return PipelineUtils.deriveLowercaseSnakeCaseNameFromCamelCase(this.wrapped.getName());
    }

    public String getFileName() {
        return this.wrapped.getFileName();
    }

    public String getPackage() {
        return this.wrapped.getPackage();
    }

    public void validate() {
        this.wrapped.validate();
    }

    @Override
    public String getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public PipelineType getType() {
        return new BasePipelineTypeDecorator(this.wrapped.getType());
    }

    @Override
    public List<FileStore> getFileStores() {
        ArrayList<FileStore> wrappedFileStores = new ArrayList<FileStore>();
        for (FileStore fileStore : this.wrapped.getFileStores()) {
            BaseFileStoreDecorator baseFileStoreDecorator = new BaseFileStoreDecorator(fileStore);
            wrappedFileStores.add(baseFileStoreDecorator);
        }
        return wrappedFileStores;
    }

    public List<BaseStepDecorator> getSteps() {
        ArrayList<BaseStepDecorator> wrappedSteps = new ArrayList<BaseStepDecorator>();
        for (Step step : this.wrapped.getSteps()) {
            BaseStepDecorator wrappedField = new BaseStepDecorator(step);
            wrappedSteps.add(wrappedField);
        }
        return wrappedSteps;
    }

    @Override
    public boolean isDataProfilingEnabled() {
        return this.wrapped.isDataProfilingEnabled();
    }

    public String getCapitalizedName() {
        return StringUtils.capitalise((String)this.getName());
    }

    public boolean hasMessaging() {
        for (Step step : this.getSteps()) {
            if (step.getInbound() != null && "messaging".equals(step.getInbound().getType())) {
                return true;
            }
            if (step.getOutbound() == null || !"messaging".equals(step.getOutbound().getType())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAsynchronousStep() {
        boolean hasAsynchronousStep = false;
        for (Step step : this.getSteps()) {
            BaseStepDecorator stepDecorator = (BaseStepDecorator)step;
            if (!stepDecorator.isAsynchronous()) continue;
            hasAsynchronousStep = true;
            break;
        }
        return hasAsynchronousStep;
    }

    public boolean hasMessagingInboundStep() {
        boolean hasMessagingInboundStep = false;
        for (Step step : this.getSteps()) {
            BaseStepDecorator stepDecorator = (BaseStepDecorator)step;
            if (!stepDecorator.hasMessagingInbound()) continue;
            hasMessagingInboundStep = true;
            break;
        }
        return hasMessagingInboundStep;
    }

    public Step getStepByType(String type) {
        Step stepByType = null;
        for (Step step : this.getSteps()) {
            if (!type.equals(step.getType())) continue;
            stepByType = step;
            break;
        }
        return stepByType;
    }

    public boolean isHiveSupportNeeded() {
        boolean persistTypeHive = this.hasPersistType(PersistType.HIVE);
        boolean isMetadataEnabled = this.isMetadataNeeded();
        return isMetadataEnabled || persistTypeHive;
    }

    public boolean isSedonaSupportNeeded() {
        return this.hasPlatform(PipelinePlatformEnum.SEDONA);
    }

    public boolean isDeltaSupportNeeded() {
        return this.hasPersistType(PersistType.DELTA_LAKE);
    }

    public boolean isPostgresSupportNeeded() {
        return this.hasPersistType(PersistType.POSTGRES);
    }

    public boolean isRdbmsSupportNeeded() {
        return this.hasPersistType(PersistType.RDBMS);
    }

    public boolean isElasticsearchSupportNeeded() {
        return this.hasPersistType(PersistType.ELASTICSEARCH);
    }

    public boolean isNeo4jSupportNeeded() {
        return this.hasPersistType(PersistType.NEO4J);
    }

    public boolean isAlertingSupportNeeded() {
        return this.getSteps().stream().anyMatch(BaseStepDecorator::isAlertingEnabled);
    }

    public boolean isDataProfilingSupportNeeded() {
        boolean enableDataProfilingSupport = false;
        for (Step step : this.getSteps()) {
            if (step.getDataProfiling() != null && !step.getDataProfiling().isEnabled().booleanValue()) continue;
            enableDataProfilingSupport = true;
            break;
        }
        return enableDataProfilingSupport;
    }

    public boolean isModelLineageSupportNeeded() {
        return this.getSteps().stream().anyMatch(step -> step.isModelLineageEnabled());
    }

    public boolean isMetadataNeeded() {
        return this.getSteps().stream().anyMatch(BaseStepDecorator::isMetadataEnabled);
    }

    private boolean hasPersistType(PersistType persistType) {
        boolean hasPersistType = false;
        if (persistType != null) {
            for (Step step : this.getSteps()) {
                if (!PersistType.hasPersistType(step.getPersist(), persistType)) continue;
                hasPersistType = true;
                break;
            }
        } else {
            throw new GenerationException("A valid persistType is required!");
        }
        return hasPersistType;
    }

    private boolean hasPlatform(PipelinePlatformEnum platform) {
        boolean hasPlatform = false;
        List<Platform> platforms = this.getType().getPlatforms();
        if (CollectionUtils.isNotEmpty(platforms)) {
            List platformNames = platforms.stream().map(Metamodel::getName).collect(Collectors.toList());
            hasPlatform = platformNames.contains(platform.getPlatformName());
        }
        return hasPlatform;
    }

    @Override
    public boolean requiresAirflow() {
        return this.getType().getExecutionHelpers() != null && this.getType().getExecutionHelpers().contains(PipelineExecuterHelperEnum.AIRFLOW.getExecutionHelperType());
    }

    @Override
    public boolean getDataLineage() {
        return this.wrapped.getDataLineage();
    }
}

