/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.BaseRecordFieldDecorator;
import com.boozallen.aiops.mda.metamodel.element.DataAccess;
import com.boozallen.aiops.mda.metamodel.element.Framework;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.SchemaField;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelUtils;

public class BaseRecordDecorator
implements Record {
    protected Record wrapped;

    public BaseRecordDecorator(Record recordToDecorate) {
        MetamodelUtils.validateWrappedInstanceIsNonNull(this.getClass(), (Object)recordToDecorate);
        this.wrapped = recordToDecorate;
    }

    public String getPackage() {
        return this.wrapped.getPackage();
    }

    public String getFileName() {
        return this.wrapped.getFileName();
    }

    @Override
    public String getTitle() {
        return this.wrapped.getTitle();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void validate() {
        this.wrapped.validate();
    }

    @Override
    public String getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public DataAccess getDataAccess() {
        return this.wrapped.getDataAccess();
    }

    @Override
    public List<RecordField> getFields() {
        return this.wrapped.getFields();
    }

    @Override
    public List<Framework> getFrameworks() {
        return this.wrapped.getFrameworks();
    }

    public String getCapitalizedName() {
        return StringUtils.capitalize((String)this.getName());
    }

    public String getLowerCamelCaseName() {
        return PipelineUtils.deriveLowerCamelNameFromUpperCamelName(this.getName());
    }

    public boolean hasFieldValidations() {
        boolean hasFieldValidations = false;
        for (RecordField field : this.getFields()) {
            BaseRecordFieldDecorator baseField = (BaseRecordFieldDecorator)field;
            if (!baseField.isRequired().booleanValue() && !baseField.hasValidation()) continue;
            hasFieldValidations = true;
            break;
        }
        return hasFieldValidations;
    }

    public String getSchema() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        List fieldSchemas = this.getFields().stream().map(rf -> new SchemaField((BaseRecordFieldDecorator)rf)).collect(Collectors.toList());
        return mapper.writeValueAsString(fieldSchemas);
    }
}

