/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.BaseDictionaryTypeDecorator;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.RecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.Validation;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelUtils;

public class BaseRecordFieldDecorator
implements RecordField {
    protected RecordField wrapped;

    public BaseRecordFieldDecorator(RecordField recordFieldToDecorate) {
        MetamodelUtils.validateWrappedInstanceIsNonNull(this.getClass(), (Object)recordFieldToDecorate);
        this.wrapped = recordFieldToDecorate;
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public String getColumn() {
        return this.wrapped.getColumn();
    }

    @Override
    public Boolean isRequired() {
        return this.wrapped.isRequired() != null && this.wrapped.isRequired() != false;
    }

    @Override
    public String getProtectionPolicy() {
        return this.wrapped.getProtectionPolicy();
    }

    @Override
    public String getEthicsPolicy() {
        return this.wrapped.getEthicsPolicy();
    }

    @Override
    public String getDriftPolicy() {
        return this.wrapped.getDriftPolicy();
    }

    @Override
    public String getSecurityPolicy() {
        return this.wrapped.getSecurityPolicy();
    }

    public void validate() {
        this.wrapped.validate();
    }

    @Override
    public RecordFieldType getType() {
        return this.wrapped.getType();
    }

    @Override
    public String getDescription() {
        return this.wrapped.getDescription();
    }

    public String getCapitalizedName() {
        return StringUtils.capitalize((String)this.getName());
    }

    public String getUpperSnakecaseName() {
        return PipelineUtils.deriveUpperUnderscoreNameFromUpperCamelName(this.getName());
    }

    public String getShortType() {
        String shortType = null;
        RecordFieldType fieldType = this.getType();
        if (fieldType.isDictionaryTyped()) {
            BaseDictionaryTypeDecorator dictionaryType = (BaseDictionaryTypeDecorator)fieldType.getDictionaryType();
            shortType = dictionaryType.isComplex() ? dictionaryType.getCapitalizedName() : dictionaryType.getShortType();
        } else if (fieldType.isCompositeTyped()) {
            throw new GenerationException("Composite typed field not supported yet!");
        }
        return shortType;
    }

    public boolean hasValidation() {
        boolean hasValidation = false;
        RecordFieldType fieldType = this.getType();
        if (fieldType.isDictionaryTyped()) {
            BaseDictionaryTypeDecorator dictionaryType = (BaseDictionaryTypeDecorator)fieldType.getDictionaryType();
            hasValidation = dictionaryType.hasValidationConstraints();
        }
        return hasValidation;
    }

    public Validation getValidation() {
        RecordFieldType fieldType = this.getType();
        if (this.hasValidation()) {
            BaseDictionaryTypeDecorator dictionaryType = (BaseDictionaryTypeDecorator)fieldType.getDictionaryType();
            return dictionaryType.getValidation();
        }
        return null;
    }

    public String getDriftPolicyEnumValue() {
        Object driftPolicyValue;
        if (StringUtils.isNotBlank((CharSequence)this.getDriftPolicy())) {
            if (this.hasOverriddenDriftPolicy()) {
                driftPolicyValue = this.getQuotationString() + this.getDriftPolicy() + this.getQuotationString();
            } else {
                BaseDictionaryTypeDecorator dictionaryType = (BaseDictionaryTypeDecorator)this.getType().getDictionaryType();
                driftPolicyValue = dictionaryType.getCapitalizedName() + ".DRIFT_POLICY";
            }
        } else {
            driftPolicyValue = this.getNullString();
        }
        return driftPolicyValue;
    }

    public String getEthicsPolicyEnumValue() {
        Object ethicsPolicyValue;
        if (StringUtils.isNotBlank((CharSequence)this.getEthicsPolicy())) {
            if (this.hasOverriddenEthicsPolicy()) {
                ethicsPolicyValue = this.getQuotationString() + this.getEthicsPolicy() + this.getQuotationString();
            } else {
                BaseDictionaryTypeDecorator dictionaryType = (BaseDictionaryTypeDecorator)this.getType().getDictionaryType();
                ethicsPolicyValue = dictionaryType.getCapitalizedName() + ".ETHICS_POLICY";
            }
        } else {
            ethicsPolicyValue = this.getNullString();
        }
        return ethicsPolicyValue;
    }

    public String getProtectionPolicyEnumValue() {
        Object protectionPolicyValue;
        if (StringUtils.isNotBlank((CharSequence)this.getProtectionPolicy())) {
            if (this.hasOverriddenProtectionPolicy()) {
                protectionPolicyValue = this.getQuotationString() + this.getProtectionPolicy() + this.getQuotationString();
            } else {
                BaseDictionaryTypeDecorator dictionaryType = (BaseDictionaryTypeDecorator)this.getType().getDictionaryType();
                protectionPolicyValue = dictionaryType.getCapitalizedName() + ".PROTECTION_POLICY";
            }
        } else {
            protectionPolicyValue = this.getNullString();
        }
        return protectionPolicyValue;
    }

    protected String getQuotationString() {
        return "\"";
    }

    protected String getNullString() {
        return "null";
    }

    public boolean hasOverriddenDriftPolicy() {
        String baseDriftPolicy = null;
        RecordFieldType fieldType = this.getType();
        if (fieldType.isDictionaryTyped()) {
            baseDriftPolicy = fieldType.getDictionaryType().getDriftPolicy();
        }
        return StringUtils.isNotBlank((CharSequence)this.getDriftPolicy()) && !this.getDriftPolicy().equals(baseDriftPolicy);
    }

    public boolean hasOverriddenEthicsPolicy() {
        String baseEthicsPolicy = null;
        RecordFieldType fieldType = this.getType();
        if (fieldType.isDictionaryTyped()) {
            baseEthicsPolicy = fieldType.getDictionaryType().getEthicsPolicy();
        }
        return StringUtils.isNotBlank((CharSequence)this.getEthicsPolicy()) && !this.getEthicsPolicy().equals(baseEthicsPolicy);
    }

    public boolean hasOverriddenProtectionPolicy() {
        String baseProtectionPolicy = null;
        RecordFieldType fieldType = this.getType();
        if (fieldType.isDictionaryTyped()) {
            baseProtectionPolicy = fieldType.getDictionaryType().getProtectionPolicy();
        }
        return StringUtils.isNotBlank((CharSequence)this.getProtectionPolicy()) && !this.getProtectionPolicy().equals(baseProtectionPolicy);
    }

    public String getFieldName() {
        String fieldName = !StringUtils.isBlank((CharSequence)this.getColumn()) ? this.getColumn() : this.getName();
        return fieldName;
    }
}

