/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.common.PersistType;
import com.boozallen.aiops.mda.metamodel.element.Alerting;
import com.boozallen.aiops.mda.metamodel.element.BaseFileStoreDecorator;
import com.boozallen.aiops.mda.metamodel.element.BasePersistDecorator;
import com.boozallen.aiops.mda.metamodel.element.BasePostActionDecorator;
import com.boozallen.aiops.mda.metamodel.element.BaseProvenanceDecorator;
import com.boozallen.aiops.mda.metamodel.element.BaseStepDataBindingDecorator;
import com.boozallen.aiops.mda.metamodel.element.DataProfiling;
import com.boozallen.aiops.mda.metamodel.element.FileStore;
import com.boozallen.aiops.mda.metamodel.element.FileStoreElement;
import com.boozallen.aiops.mda.metamodel.element.ModelLineage;
import com.boozallen.aiops.mda.metamodel.element.Persist;
import com.boozallen.aiops.mda.metamodel.element.PostAction;
import com.boozallen.aiops.mda.metamodel.element.Provenance;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.StepDataBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.BaseConfigurationItemDecorator;
import org.technologybrewery.fermenter.mda.metamodel.element.ConfigurationItem;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelUtils;

public class BaseStepDecorator
implements Step {
    protected Step wrapped;

    public BaseStepDecorator(Step stepToDecorate) {
        MetamodelUtils.validateWrappedInstanceIsNonNull(this.getClass(), (Object)stepToDecorate);
        this.wrapped = stepToDecorate;
    }

    public String getFileName() {
        return this.wrapped.getFileName();
    }

    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public String getType() {
        return this.wrapped.getType();
    }

    @Override
    public Alerting getAlerting() {
        return this.wrapped.getAlerting();
    }

    @Override
    public DataProfiling getDataProfiling() {
        return this.wrapped.getDataProfiling();
    }

    @Override
    public boolean isDataProfilingEnabled() {
        return this.wrapped.isDataProfilingEnabled();
    }

    @Override
    public ModelLineage getModelLineage() {
        return this.wrapped.getModelLineage();
    }

    @Override
    public StepDataBinding getInbound() {
        BaseStepDataBindingDecorator wrappedInbound = null;
        if (this.wrapped.getInbound() != null) {
            wrappedInbound = new BaseStepDataBindingDecorator(this.wrapped.getInbound());
        }
        return wrappedInbound;
    }

    @Override
    public StepDataBinding getOutbound() {
        BaseStepDataBindingDecorator wrappedOutbound = null;
        if (this.wrapped.getOutbound() != null) {
            wrappedOutbound = new BaseStepDataBindingDecorator(this.wrapped.getOutbound());
        }
        return wrappedOutbound;
    }

    @Override
    public Persist getPersist() {
        BasePersistDecorator wrappedPersist = null;
        if (this.wrapped.getPersist() != null) {
            wrappedPersist = new BasePersistDecorator(this.wrapped.getPersist());
        }
        return wrappedPersist;
    }

    @Override
    public Provenance getProvenance() {
        BaseProvenanceDecorator wrappedProvenance = null;
        if (this.wrapped.getProvenance() != null) {
            wrappedProvenance = new BaseProvenanceDecorator(this.wrapped.getProvenance());
        }
        return wrappedProvenance;
    }

    @Override
    public List<PostAction> getPostActions() {
        ArrayList<PostAction> wrappedPostActions = new ArrayList<PostAction>();
        if (CollectionUtils.isNotEmpty(this.wrapped.getPostActions())) {
            for (PostAction postAction : this.wrapped.getPostActions()) {
                BasePostActionDecorator wrappedPostAction = new BasePostActionDecorator(postAction);
                wrappedPostActions.add(wrappedPostAction);
            }
        }
        return wrappedPostActions;
    }

    @Override
    public List<ConfigurationItem> getConfiguration() {
        ArrayList<ConfigurationItem> wrappedConfigurationItems = new ArrayList<ConfigurationItem>();
        for (ConfigurationItem configurationItem : this.wrapped.getConfiguration()) {
            BaseConfigurationItemDecorator wrappedConfigurationItem = new BaseConfigurationItemDecorator(configurationItem);
            wrappedConfigurationItems.add((ConfigurationItem)wrappedConfigurationItem);
        }
        return wrappedConfigurationItems;
    }

    @Override
    public List<String> getFileStores() {
        return this.wrapped.getFileStores();
    }

    public void validate() {
        this.wrapped.validate();
    }

    public String getCapitalizedName() {
        return StringUtils.capitalize((String)this.getName());
    }

    public boolean isPersistTypePostgres() {
        return PersistType.hasPersistType(this.getPersist(), PersistType.POSTGRES);
    }

    public boolean isPersistTypeRdbms() {
        return PersistType.hasPersistType(this.getPersist(), PersistType.RDBMS);
    }

    public boolean isPersistTypeDeltaLake() {
        return PersistType.hasPersistType(this.getPersist(), PersistType.DELTA_LAKE);
    }

    public boolean isPersistTypeHive() {
        return PersistType.hasPersistType(this.getPersist(), PersistType.HIVE);
    }

    public boolean isPersistTypeElasticsearch() {
        return PersistType.hasPersistType(this.getPersist(), PersistType.ELASTICSEARCH);
    }

    public boolean isPersistTypeNeo4j() {
        return PersistType.hasPersistType(this.getPersist(), PersistType.NEO4J);
    }

    public boolean hasNativeInbound() {
        return this.isNative(this.getInbound());
    }

    public boolean hasNativeOutbound() {
        return this.isNative(this.getOutbound());
    }

    public boolean isNative(StepDataBinding stepDataBinding) {
        return stepDataBinding != null && "native".equalsIgnoreCase(stepDataBinding.getType());
    }

    public boolean isMessaging(StepDataBinding stepDataBinding) {
        return stepDataBinding != null && "messaging".equalsIgnoreCase(stepDataBinding.getType());
    }

    public boolean isMultiMessaging(StepDataBinding stepDataBinding) {
        return stepDataBinding != null && "multimessaging".equalsIgnoreCase(stepDataBinding.getType());
    }

    public boolean hasMessagingInbound() {
        return this.isMessaging(this.getInbound());
    }

    public boolean hasMessagingOutbound() {
        return this.isMessaging(this.getOutbound()) || this.isMultiMessaging(this.getOutbound());
    }

    public boolean hasMultiMessagingOutbound() {
        return this.isMultiMessaging(this.getOutbound());
    }

    public boolean hasInboundRecordType() {
        return this.hasRecordType(this.getInbound());
    }

    public boolean hasOutboundRecordType() {
        return this.hasRecordType(this.getOutbound());
    }

    public boolean hasRecordType(StepDataBinding stepDataBinding) {
        return stepDataBinding != null && stepDataBinding.getRecordType() != null;
    }

    public boolean hasInboundNativeCollectionType() {
        return this.getInbound() != null && this.getInbound().getNativeCollectionType() != null;
    }

    public boolean isMetadataEnabled() {
        return this.isProvenanceEnabled();
    }

    public boolean isProvenanceEnabled() {
        return this.getProvenance() == null || this.getProvenance().isEnabled() != false;
    }

    public boolean isAlertingEnabled() {
        return this.getAlerting() == null || this.getAlerting().isEnabled() != false;
    }

    public boolean isModelLineageEnabled() {
        return this.getModelLineage() != null && this.getModelLineage().isEnabled() != false;
    }

    public boolean isAsynchronous() {
        return "asynchronous".equalsIgnoreCase(this.getType());
    }

    public List<FileStore> getDecoratedFileStores() {
        return this.getFileStores() != null ? this.getFileStores().stream().map(FileStoreElement::new).map(BaseFileStoreDecorator::new).collect(Collectors.toList()) : new ArrayList<FileStore>();
    }

    public boolean isGeneric() {
        return "generic".equalsIgnoreCase(this.getType());
    }
}

