/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.Validation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;

@JsonPropertyOrder(value={"name", "package", "simpleType", "validation", "protectionPolicy", "ethicsPolicy", "driftPolicy"})
public class DictionaryTypeElement
extends NamespacedMetamodelElement
implements DictionaryType {
    private String simpleType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Validation validation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String protectionPolicy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String ethicsPolicy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String driftPolicy;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String securityPolicy;

    @Override
    public String getSimpleType() {
        return this.simpleType;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Validation getValidation() {
        return this.validation;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProtectionPolicy() {
        return this.protectionPolicy;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEthicsPolicy() {
        return this.ethicsPolicy;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDriftPolicy() {
        return this.driftPolicy;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSecurityPolicy() {
        return this.securityPolicy;
    }

    public void setSimpleType(String simpleType) {
        this.simpleType = simpleType;
    }

    public void setValidation(Validation validation) {
        this.validation = validation;
    }

    public void setProtectionPolicy(String protectionPolicy) {
        this.protectionPolicy = protectionPolicy;
    }

    public void setEthicsPolicy(String ethicsPolicy) {
        this.ethicsPolicy = ethicsPolicy;
    }

    public void setDriftPolicy(String driftPolicy) {
        this.driftPolicy = driftPolicy;
    }

    public void setSecurityPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void validate() {
        super.validate();
        if (StringUtils.isBlank((CharSequence)this.getSimpleType())) {
            messageTracker.addErrorMessage("A dictionary type has been specified without a required 'simpleType'!");
        }
        this.validateProtectionPolicy();
        this.validateEthicsPolicy();
        this.validateDriftPolicy();
        if (this.validation != null) {
            this.validation.validate();
        }
    }

    private void validateProtectionPolicy() {
        if (this.protectionPolicy != null && StringUtils.isBlank((CharSequence)this.protectionPolicy)) {
            this.protectionPolicy = null;
            this.addEmptyPolicyUrnMessage("protectionPolicy");
        }
    }

    private void addEmptyPolicyUrnMessage(String fieldName) {
        messageTracker.addWarningMessage("Empty " + fieldName + " found and ignored - please remove from your DictionaryType!");
    }

    private void validateEthicsPolicy() {
        if (this.ethicsPolicy != null && StringUtils.isBlank((CharSequence)this.ethicsPolicy)) {
            this.ethicsPolicy = null;
            this.addEmptyPolicyUrnMessage("ethicsPolicy");
        }
    }

    private void validateDriftPolicy() {
        if (this.driftPolicy != null && StringUtils.isBlank((CharSequence)this.driftPolicy)) {
            this.driftPolicy = null;
            this.addEmptyPolicyUrnMessage("driftPolicy");
        }
    }

    public String getSchemaFileName() {
        return null;
    }
}

