/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.metamodel.element.FileStore;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;

public class FileStoreElement
extends MetamodelElement
implements FileStore {
    private static final Predicate<String> validName = Pattern.compile("[A-Za-z0-9]+").asMatchPredicate();

    public FileStoreElement() {
    }

    public FileStoreElement(String name) {
        this.name = name;
    }

    public void validate() {
        super.validate();
        if (!validName.test(this.name)) {
            String suggestion = ((Stream)Arrays.stream(this.name.split("[^A-Za-z0-9]+")).sequential()).map(StringUtils::lowerCase).map(StringUtils::capitalize).collect(Collectors.joining(""));
            messageTracker.addErrorMessage("File store name is not in Pascal Case: " + this.name + " (try " + suggestion + ")");
        }
    }
}

