/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.common.PersistMode;
import com.boozallen.aiops.mda.metamodel.element.Persist;
import com.boozallen.aiops.mda.metamodel.element.StepDataCollectionType;
import com.boozallen.aiops.mda.metamodel.element.StepDataRecordType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

@JsonPropertyOrder(value={"type", "mode"})
public class PersistElement
implements Persist {
    protected static MessageTracker messageTracker = MessageTracker.getInstance();
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String mode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StepDataCollectionType collectionType;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StepDataRecordType recordType;

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public StepDataCollectionType getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(StepDataCollectionType collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public StepDataRecordType getRecordType() {
        return this.recordType;
    }

    public void setRecordType(StepDataRecordType recordType) {
        this.recordType = recordType;
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.getType())) {
            messageTracker.addErrorMessage("A persist element has been specified without a required type!");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getMode()) && !PersistMode.isValid(this.getMode())) {
            messageTracker.addErrorMessage("Invalid persist mode has been specified: " + this.getMode());
        }
        if (this.getCollectionType() != null) {
            this.getCollectionType().validate();
        }
        if (this.getRecordType() != null) {
            this.getRecordType().validate();
        }
    }
}

