/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.common.PipelineExecuterHelperEnum;
import com.boozallen.aiops.mda.metamodel.element.FileStore;
import com.boozallen.aiops.mda.metamodel.element.Pipeline;
import com.boozallen.aiops.mda.metamodel.element.PipelineType;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;

@JsonPropertyOrder(value={"package", "name", "description", "type"})
public class PipelineElement
extends NamespacedMetamodelElement
implements Pipeline {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonProperty(value="type")
    private PipelineType type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<FileStore> fileStores = new ArrayList<FileStore>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean dataLineage;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Step> steps = new ArrayList<Step>();

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="type")
    public PipelineType getType() {
        return this.type;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<FileStore> getFileStores() {
        return this.fileStores;
    }

    public void setFileStores(List<FileStore> fileStores) {
        this.fileStores = fileStores;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    @JsonIgnore
    public boolean isDataProfilingEnabled() {
        boolean result = false;
        if (this.steps != null) {
            for (Step step : this.steps) {
                if (!step.isDataProfilingEnabled()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean requiresAirflow() {
        return this.getType().getExecutionHelpers() != null && this.getType().getExecutionHelpers().contains(PipelineExecuterHelperEnum.AIRFLOW.getExecutionHelperType());
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public boolean getDataLineage() {
        return this.dataLineage;
    }

    public void setDataLineage(boolean enabled) {
        this.dataLineage = enabled;
    }

    public String getSchemaFileName() {
        return "aiops-pipeline-schema.json";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(PipelineType type) {
        this.type = type;
    }

    public void addStep(Step step) {
        this.steps.add(step);
    }

    public void validate() {
        super.validate();
        this.type.validate();
        HashSet<String> validFileStoreNames = new HashSet<String>();
        for (FileStore fileStore : this.fileStores) {
            fileStore.validate();
            validFileStoreNames.add(fileStore.getName());
        }
        boolean isMlPipeline = this.getType().getName().equals("machine-learning");
        if (isMlPipeline && this.getDataLineage()) {
            messageTracker.addErrorMessage("Pipeline [" + this.getName() + "] cannot have data lineage because it is a machine-learning pipeline");
        }
        for (Step step : this.steps) {
            String invalidStores;
            step.validate();
            if (isMlPipeline) {
                this.validateMlStep(step);
            } else {
                this.validateDataStep(step);
            }
            if (step.getFileStores() == null || !StringUtils.isNotBlank((CharSequence)(invalidStores = step.getFileStores().stream().filter(store -> !validFileStoreNames.contains(store)).collect(Collectors.joining(", "))))) continue;
            messageTracker.addErrorMessage("Step [" + step.getName() + "] contains invalid file store references: " + invalidStores);
        }
    }

    private void validateDataStep(Step step) {
        if (step.getModelLineage() != null) {
            messageTracker.addErrorMessage("Pipeline [" + this.getName() + "] has invalid step [" + step.getName() + "] because data-flow pipelines do not support model lineage");
        }
    }

    private void validateMlStep(Step step) {
        if (step.getDataProfiling() != null) {
            messageTracker.addErrorMessage("Pipeline [" + this.getName() + "] cannot have data profiling because it is a machine-learning pipeline");
        }
    }
}

