/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.common.PipelineEnum;
import com.boozallen.aiops.mda.generator.common.PipelineImplementationEnum;
import com.boozallen.aiops.mda.generator.common.PipelinePlatformEnum;
import com.boozallen.aiops.mda.metamodel.element.PipelineType;
import com.boozallen.aiops.mda.metamodel.element.Platform;
import com.boozallen.aiops.mda.metamodel.element.Versioning;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;

@JsonPropertyOrder(value={"name", "implementation", "versioning", "platforms", "executionHelpers"})
public class PipelineTypeElement
extends MetamodelElement
implements PipelineType {
    private String implementation;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Versioning versioning;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String storage;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Platform> platforms;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> executionHelpers;

    @Override
    public String getImplementation() {
        return this.implementation;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Versioning getVersioning() {
        return this.versioning;
    }

    @Override
    public List<Platform> getPlatforms() {
        return this.platforms;
    }

    @Override
    public List<String> getExecutionHelpers() {
        return this.executionHelpers;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setVersioning(Versioning versioning) {
        this.versioning = versioning;
    }

    public void setPlatforms(List<Platform> platforms) {
        this.platforms = platforms;
    }

    public void setExecutionHelpers(List<String> helpers) {
        this.executionHelpers = helpers;
    }

    public void validate() {
        super.validate();
        if (!PipelineEnum.isValidType(this.getName())) {
            messageTracker.addErrorMessage("A pipeline type with an unrecognized name (" + this.name + ") has been specified! Must be one of " + PipelineEnum.getPossibleValues());
        }
        if (StringUtils.isBlank((CharSequence)this.getImplementation())) {
            messageTracker.addErrorMessage("A pipeline type has been specified without a required implementation!");
        }
        if (!PipelineImplementationEnum.isValidImplementation(this.getImplementation())) {
            messageTracker.addErrorMessage("A pipeline type has been specified that does not match any expected implementation! Must be one of " + PipelineImplementationEnum.getPossibleValues());
        }
        if (this.getVersioning() != null && !PipelineEnum.MACHINE_LEARNING.equalsIgnoreCase(this.getName())) {
            messageTracker.addErrorMessage("Versioning is only valid for machine-learning pipeline types!");
        }
        if (CollectionUtils.isNotEmpty(this.getPlatforms())) {
            for (Platform platform : this.getPlatforms()) {
                if (PipelinePlatformEnum.isValidPipelinePlatform(platform.getName(), this.getImplementation())) continue;
                messageTracker.addErrorMessage("Invalid platform specified for " + this.getImplementation() + " pipeline: " + platform);
            }
        }
    }
}

