/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.generator.post.action.ModelConversionType;
import com.boozallen.aiops.mda.generator.post.action.PostActionType;
import com.boozallen.aiops.mda.metamodel.element.PostAction;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

@JsonPropertyOrder(value={"name", "type", "modelTarget", "modelSource"})
public class PostActionElement
extends MetamodelElement
implements PostAction {
    protected static MessageTracker messageTracker = MessageTracker.getInstance();
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String modelTarget;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String modelSource;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getModelTarget() {
        return this.modelTarget;
    }

    @Override
    public String getModelSource() {
        return this.modelSource;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setModelTarget(String modelTarget) {
        this.modelTarget = modelTarget;
    }

    public void setModelSource(String modelSource) {
        this.modelSource = modelSource;
    }

    public void validate() {
        super.validate();
        if (StringUtils.isNotBlank((CharSequence)this.getType())) {
            this.validatePostActionType();
        }
    }

    private void validatePostActionType() {
        PostActionType postActionType = PostActionType.getPostActionType(this);
        if (postActionType == null) {
            messageTracker.addWarningMessage("Unknown type '" + this.getType() + "' for post action " + this.getName() + " - defaulting to freeform type");
            this.setType(PostActionType.FREEFORM.getValue());
        }
        if (postActionType == PostActionType.MODEL_CONVERSION) {
            ModelConversionType modelConversionType;
            if (StringUtils.isBlank((CharSequence)this.getModelSource()) || StringUtils.isBlank((CharSequence)this.getModelTarget())) {
                messageTracker.addErrorMessage("A model-conversion post action has been specified without a modelSource and/or modelTarget!");
            }
            if ((modelConversionType = ModelConversionType.getModelConversionType(this)) == null) {
                messageTracker.addWarningMessage("Unknown modelTarget '" + this.getModelTarget() + "' for post action " + this.getName() + " - default to custom modelTarget");
                this.setModelTarget(ModelConversionType.CUSTOM.getValue());
            }
        }
    }
}

