/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.metamodel.element.DataAccess;
import com.boozallen.aiops.mda.metamodel.element.Framework;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.NamespacedMetamodelElement;

@JsonPropertyOrder(value={"package", "name", "title", "description", "dataAccess", "featureRegistration", "fields", "frameworks"})
public class RecordElement
extends NamespacedMetamodelElement
implements Record {
    @JsonIgnore
    protected ManualActionNotificationService manualActionNotificationService = new ManualActionNotificationService();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String title;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DataAccess dataAccess;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object featureRegistration;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<RecordField> fields = new ArrayList<RecordField>();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Framework> frameworks = new ArrayList<Framework>();

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return StringUtils.isEmpty((CharSequence)this.title) ? this.name : this.title;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DataAccess getDataAccess() {
        return this.dataAccess;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<RecordField> getFields() {
        return this.fields;
    }

    public void addField(RecordField field) {
        this.fields.add(field);
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Framework> getFrameworks() {
        return this.frameworks;
    }

    public void addFramework(Framework framework) {
        this.frameworks.add(framework);
    }

    public void validate() {
        for (RecordField field : this.fields) {
            field.validate();
        }
        if (this.featureRegistration != null) {
            this.manualActionNotificationService.addSchemaElementDeprecationNotice("featureRegistration", "Record");
        }
    }

    public String getSchemaFileName() {
        return "aiops-record-schema.json";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public void setFeatureRegistration(Object featureRegistration) {
        this.featureRegistration = featureRegistration;
    }
}

