/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.metamodel.element.AbstractFieldElement;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.RecordDriftPolicyFilter;
import com.boozallen.aiops.mda.metamodel.element.RecordEthicsPolicyFilter;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.RecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.RecordProtectionPolicyFilter;
import com.boozallen.aiops.mda.metamodel.element.RecordSecurityPolicyFilter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.apache.commons.lang3.StringUtils;

@JsonPropertyOrder(value={"name", "description", "type", "column", "required", "validation", "protectionPolicy", "ethicsPolicy", "driftPolicy"})
public class RecordFieldElement
extends AbstractFieldElement
implements RecordField {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RecordFieldType type;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public RecordFieldType getType() {
        return this.type;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=RecordProtectionPolicyFilter.class)
    public String getProtectionPolicy() {
        RecordFieldType recordFieldType;
        String protectionPolicy = super.getProtectionPolicy();
        if (StringUtils.isBlank((CharSequence)protectionPolicy) && (recordFieldType = this.getType()).isDictionaryTyped()) {
            DictionaryType dictionaryType = recordFieldType.getDictionaryType();
            protectionPolicy = dictionaryType.getProtectionPolicy();
        }
        return protectionPolicy;
    }

    boolean protectionPolicyOverrideExists() {
        String overidePolicy = super.getProtectionPolicy();
        String backingPolicy = this.type.isDictionaryTyped() ? this.type.getDictionaryType().getProtectionPolicy() : null;
        return StringUtils.compare((String)overidePolicy, (String)backingPolicy) != 0;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=RecordEthicsPolicyFilter.class)
    public String getEthicsPolicy() {
        RecordFieldType recordFieldType;
        String ethicsPolicy = super.getEthicsPolicy();
        if (StringUtils.isBlank((CharSequence)ethicsPolicy) && (recordFieldType = this.getType()).isDictionaryTyped()) {
            DictionaryType dictionaryType = recordFieldType.getDictionaryType();
            ethicsPolicy = dictionaryType.getEthicsPolicy();
        }
        return ethicsPolicy;
    }

    boolean ethicsPolicyOverrideExists() {
        String overidePolicy = super.getEthicsPolicy();
        String backingPolicy = this.type.isDictionaryTyped() ? this.type.getDictionaryType().getEthicsPolicy() : null;
        return StringUtils.compare((String)overidePolicy, (String)backingPolicy) != 0;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=RecordDriftPolicyFilter.class)
    public String getDriftPolicy() {
        RecordFieldType recordFieldType;
        String driftPolicy = super.getDriftPolicy();
        if (StringUtils.isBlank((CharSequence)driftPolicy) && (recordFieldType = this.getType()).isDictionaryTyped()) {
            DictionaryType dictionaryType = recordFieldType.getDictionaryType();
            driftPolicy = dictionaryType.getDriftPolicy();
        }
        return driftPolicy;
    }

    boolean driftPolicyOverrideExists() {
        String overidePolicy = super.getDriftPolicy();
        String backingPolicy = this.type.isDictionaryTyped() ? this.type.getDictionaryType().getDriftPolicy() : null;
        return StringUtils.compare((String)overidePolicy, (String)backingPolicy) != 0;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=RecordSecurityPolicyFilter.class)
    public String getSecurityPolicy() {
        RecordFieldType recordFieldType;
        String securityPolicy = super.getSecurityPolicy();
        if (StringUtils.isBlank((CharSequence)securityPolicy) && (recordFieldType = this.getType()).isDictionaryTyped()) {
            DictionaryType dictionaryType = recordFieldType.getDictionaryType();
            securityPolicy = dictionaryType.getSecurityPolicy();
        }
        return securityPolicy;
    }

    boolean securityPolicyOverrideExists() {
        String overidePolicy = super.getSecurityPolicy();
        String backingPolicy = this.type.isDictionaryTyped() ? this.type.getDictionaryType().getSecurityPolicy() : null;
        return StringUtils.compare((String)overidePolicy, (String)backingPolicy) != 0;
    }

    public void setType(RecordFieldType type) {
        this.type = type;
    }

    @Override
    public void validate() {
        super.validate();
        this.type.validate();
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

