/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.ManualActionNotificationService;
import com.boozallen.aiops.mda.metamodel.element.Alerting;
import com.boozallen.aiops.mda.metamodel.element.DataProfiling;
import com.boozallen.aiops.mda.metamodel.element.ModelLineage;
import com.boozallen.aiops.mda.metamodel.element.Persist;
import com.boozallen.aiops.mda.metamodel.element.PostAction;
import com.boozallen.aiops.mda.metamodel.element.Provenance;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.StepDataBinding;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.metamodel.element.ConfigurationItem;
import org.technologybrewery.fermenter.mda.metamodel.element.MetamodelElement;

@JsonPropertyOrder(value={"name", "type", "inbound", "outbound", "persist", "provenance", "featureDiscovery", "alerting", "modelLineage", "dataProfiling", "postActions"})
public class StepElement
extends MetamodelElement
implements Step {
    @JsonIgnore
    private ManualActionNotificationService manualActionNotificationService;
    private String type;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object featureDiscovery;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StepDataBinding inbound;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private StepDataBinding outbound;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Persist persist;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Provenance provenance;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Alerting alerting;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private DataProfiling dataProfiling;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<PostAction> postActions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ConfigurationItem> configuration;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> fileStores;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ModelLineage modelLineage;

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StepDataBinding getInbound() {
        return this.inbound;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StepDataBinding getOutbound() {
        return this.outbound;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Persist getPersist() {
        return this.persist;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Provenance getProvenance() {
        return this.provenance;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Alerting getAlerting() {
        return this.alerting;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DataProfiling getDataProfiling() {
        return this.dataProfiling;
    }

    @Override
    @JsonIgnore
    public boolean isDataProfilingEnabled() {
        return this.dataProfiling.isEnabled();
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ModelLineage getModelLineage() {
        return this.modelLineage;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PostAction> getPostActions() {
        return this.postActions;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<ConfigurationItem> getConfiguration() {
        return this.configuration;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getFileStores() {
        return this.fileStores;
    }

    public void setFileStores(List<String> fileStores) {
        this.fileStores = fileStores;
    }

    public void setAlerting(Alerting alerting) {
        this.alerting = alerting;
    }

    public void setDataProfiling(DataProfiling dataProfiling) {
        this.dataProfiling = dataProfiling;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setInbound(StepDataBinding inbound) {
        this.inbound = inbound;
    }

    public void setOutbound(StepDataBinding outbound) {
        this.outbound = outbound;
    }

    public void setPersist(Persist persist) {
        this.persist = persist;
    }

    public void setProvenance(Provenance provenance) {
        this.provenance = provenance;
    }

    public void setModelLineage(ModelLineage modelLineage) {
        this.modelLineage = modelLineage;
    }

    public void addPostAction(PostAction postAction) {
        if (this.postActions == null) {
            this.postActions = new ArrayList<PostAction>();
        }
        this.postActions.add(postAction);
    }

    public void addConfigurationItem(ConfigurationItem configurationItem) {
        if (this.configuration == null) {
            this.configuration = new ArrayList<ConfigurationItem>();
        }
        this.configuration.add(configurationItem);
    }

    public void validate() {
        super.validate();
        if (StringUtils.isBlank((CharSequence)this.getType())) {
            messageTracker.addErrorMessage("A pipeline type has been specified without a required type!");
        }
        if (this.inbound != null) {
            this.inbound.validate();
        }
        if (this.outbound != null) {
            this.outbound.validate();
        }
        if (this.persist != null) {
            this.persist.validate();
        }
        if (this.featureDiscovery != null) {
            this.manualActionNotificationService.addSchemaElementDeprecationNotice("featureDiscovery", "Pipeline/step");
        }
        if (this.getConfiguration() != null) {
            for (ConfigurationItem configurationItem : this.getConfiguration()) {
                configurationItem.validate();
            }
        }
        if (this.getPostActions() != null) {
            if ("training".equals(this.getType())) {
                for (PostAction postAction : this.getPostActions()) {
                    postAction.validate();
                }
            } else {
                messageTracker.addWarningMessage("Post actions found on non-training step " + this.getName() + " - post actions will be ignored for this step!");
            }
        }
    }
}

