/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element;

import com.boozallen.aiops.mda.metamodel.element.Validation;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.util.MessageTracker;

@JsonPropertyOrder(value={"package", "name", "maxLength", "minLength", "maxValue", "minValue", "scale", "formats"})
public class ValidationElement
implements Validation {
    protected static MessageTracker messageTracker = MessageTracker.getInstance();
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer maxLength;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer minLength;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String maxValue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String minValue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer scale;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Collection<String> formats;

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getMinLength() {
        return this.minLength;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMaxValue() {
        return this.maxValue;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMinValue() {
        return this.minValue;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getScale() {
        return this.scale;
    }

    @Override
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Collection<String> getFormats() {
        return this.formats;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setFormats(Collection<String> formats) {
        this.formats = formats;
    }

    public void validate() {
        this.validateLengths();
        this.validateRange();
        this.validateFormats();
        this.validateScale();
    }

    private void validateLengths() {
        if (this.minLength != null && this.minLength < 0) {
            messageTracker.addErrorMessage("minLength '" + this.minLength + "' cannot be less than zero!");
        }
        if (this.maxLength != null && this.maxLength < 0) {
            messageTracker.addErrorMessage("maxLength '" + this.maxLength + "' cannot be less than zero!");
        }
        if (this.maxLength != null && this.minLength != null && this.minLength.compareTo(this.maxLength) > 0) {
            messageTracker.addErrorMessage("minLength '" + this.minLength + "' exceeds maxLength '" + this.maxLength + "'!");
        }
    }

    private void validateRange() {
        BigDecimal numericMaxValue;
        BigDecimal numericMinValue;
        if (this.maxValue != null && this.minValue != null && (numericMinValue = new BigDecimal(this.minValue)).compareTo(numericMaxValue = new BigDecimal(this.maxValue)) > 0) {
            messageTracker.addErrorMessage("minValue '" + numericMinValue + "' exceeds maxValue '" + numericMaxValue + "'!");
        }
    }

    private void validateFormats() {
        if (CollectionUtils.isNotEmpty(this.formats)) {
            boolean foundEmptyFormats = false;
            ArrayList<String> trimmedFormats = new ArrayList<String>();
            for (String format : this.formats) {
                if (!StringUtils.isNotBlank((CharSequence)format)) continue;
                trimmedFormats.add(format.trim());
                foundEmptyFormats = true;
            }
            this.formats = trimmedFormats;
            if (foundEmptyFormats) {
                messageTracker.addWarningMessage("At least one empty format was stripped - please remove from your Validation definition!");
            }
        }
    }

    private void validateScale() {
        if (this.scale != null && this.scale < 0) {
            messageTracker.addErrorMessage("scale '" + this.scale + "' cannot be less than zero!");
        }
    }

    public boolean hasValidationContraints() {
        return this.maxLength != null || this.minLength != null || this.maxValue != null || this.minValue != null || this.scale != null || this.formats != null;
    }
}

