/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.java;

import com.boozallen.aiops.mda.metamodel.element.BaseDictionaryTypeDecorator;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.util.JavaElementUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import org.technologybrewery.fermenter.mda.TypeManager;

public class JavaDictionaryType
extends BaseDictionaryTypeDecorator {
    private static final List<String> VALIDATABLE_TYPES = Arrays.asList("BigDecimal", "Double", "Float", "Integer", "Long", "Short", "String");
    private Set<String> imports = new TreeSet<String>();

    public JavaDictionaryType(DictionaryType dictionaryTypeToDecorate) {
        super(dictionaryTypeToDecorate);
    }

    @Override
    public void validate() {
        super.validate();
        this.validateValidations(VALIDATABLE_TYPES, this.isString(), this.isDecimal());
    }

    public Set<String> getBaseImports() {
        this.addDictionaryTypeImport();
        if (this.hasValidationConstraints()) {
            this.addValidationImports();
        }
        return this.imports;
    }

    public Set<String> getImplImports() {
        this.addDictionaryTypeImport();
        return this.imports;
    }

    public String getCommaSeparatedFormats() {
        StringJoiner stringJoiner = new StringJoiner(", ");
        if (this.hasFormatValidation()) {
            for (String format : this.getValidation().getFormats()) {
                String escapedFormat = format.replace("\\", "\\\\");
                stringJoiner.add("\"" + escapedFormat + "\"");
            }
        }
        return stringJoiner.toString();
    }

    public boolean isString() {
        return "String".equals(this.getShortType());
    }

    public boolean isDecimal() {
        return "BigDecimal".equals(this.getShortType()) || "Double".equals(this.getShortType()) || "Float".equals(this.getShortType());
    }

    private void addDictionaryTypeImport() {
        String fullyQualifiedType = this.getFullyQualifiedType();
        if (JavaElementUtils.isImportNeeded(fullyQualifiedType)) {
            this.imports.add(fullyQualifiedType);
        }
    }

    private void addValidationImports() {
        this.imports.add("com.boozallen.aissemble.core.exception.ValidationException");
        if (this.isString()) {
            this.imports.add("org.apache.commons.lang3.StringUtils");
        }
        if (this.hasFormatValidation()) {
            this.imports.add("java.util.Arrays");
            this.imports.add(TypeManager.getFullyQualifiedType((String)"list"));
        }
        if (this.hasScaleValidation()) {
            this.imports.add("java.math.RoundingMode");
            this.imports.add(TypeManager.getFullyQualifiedType((String)"decimal"));
        }
    }
}

