/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.java;

import com.boozallen.aiops.mda.metamodel.element.BaseRecordDecorator;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.java.JavaDictionaryType;
import com.boozallen.aiops.mda.metamodel.element.java.JavaRecordField;
import com.boozallen.aiops.mda.metamodel.element.java.JavaRecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.util.JavaElementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.TypeManager;
import org.technologybrewery.fermenter.mda.generator.GenerationException;

public class JavaRecord
extends BaseRecordDecorator {
    private Set<String> imports = new TreeSet<String>();

    public JavaRecord(Record recordToDecorate) {
        super(recordToDecorate);
    }

    @Override
    public List<RecordField> getFields() {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (RecordField field : super.getFields()) {
            fields.add(new JavaRecordField(field));
        }
        return fields;
    }

    public Set<String> getBaseImports() {
        for (RecordField field : this.getFields()) {
            JavaRecordField javaField = (JavaRecordField)field;
            this.addFieldImports(javaField);
        }
        this.imports.add("java.util.Map");
        this.imports.add("java.util.HashMap");
        return this.imports;
    }

    public Set<String> getEnumImports() {
        for (RecordField field : this.getFields()) {
            JavaRecordField javaField = (JavaRecordField)field;
            if (!this.hasDriftPolicy(javaField) && !this.hasEthicsPolicy(javaField) && !this.hasProtectionPolicy(javaField)) continue;
            this.addDictionaryTypeImports(javaField, true);
        }
        this.imports.add(TypeManager.getFullyQualifiedType((String)"list"));
        this.imports.add("java.util.ArrayList");
        this.imports.add("org.apache.commons.lang3.StringUtils");
        return this.imports;
    }

    private boolean hasDriftPolicy(JavaRecordField javaField) {
        return StringUtils.isNotBlank((CharSequence)javaField.getDriftPolicy()) && !javaField.hasOverriddenDriftPolicy();
    }

    private boolean hasEthicsPolicy(JavaRecordField javaField) {
        return StringUtils.isNotBlank((CharSequence)javaField.getEthicsPolicy()) && !javaField.hasOverriddenEthicsPolicy();
    }

    private boolean hasProtectionPolicy(JavaRecordField javaField) {
        return StringUtils.isNotBlank((CharSequence)javaField.getProtectionPolicy()) && !javaField.hasOverriddenProtectionPolicy();
    }

    public Set<String> getDataAccessImports() {
        for (RecordField field : this.getFields()) {
            JavaRecordField javaField = (JavaRecordField)field;
            this.addSimpleTypeImport(javaField);
        }
        return this.imports;
    }

    private void addFieldImports(JavaRecordField field) {
        this.addDictionaryTypeImports(field, false);
        if (field.isRequired().booleanValue() || field.hasValidation()) {
            this.imports.add("com.boozallen.aissemble.core.exception.ValidationException");
        }
    }

    private void addDictionaryTypeImports(JavaRecordField field, boolean forEnum) {
        JavaRecordFieldType fieldType = (JavaRecordFieldType)field.getType();
        if (fieldType.isDictionaryTyped()) {
            JavaDictionaryType dictionaryType = (JavaDictionaryType)fieldType.getDictionaryType();
            if (dictionaryType.isComplex()) {
                String dictionaryTypePackage = fieldType.getPackage();
                String generatedClassImport = dictionaryTypePackage + "." + dictionaryType.getCapitalizedName();
                this.imports.add(generatedClassImport);
            }
            if (!forEnum) {
                this.addSimpleTypeImport(field);
            }
        } else {
            throw new GenerationException("Composite typed field not supported yet!");
        }
    }

    private void addSimpleTypeImport(JavaRecordField field) {
        JavaRecordFieldType fieldType = (JavaRecordFieldType)field.getType();
        JavaDictionaryType dictionaryType = (JavaDictionaryType)fieldType.getDictionaryType();
        String simpleTypeImport = dictionaryType.getFullyQualifiedType();
        if (JavaElementUtils.isImportNeeded(simpleTypeImport)) {
            this.imports.add(dictionaryType.getFullyQualifiedType());
        }
    }
}

