/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.java;

import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.AIOpsModelInstanceRepostory;
import com.boozallen.aiops.mda.metamodel.element.BaseStepDecorator;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.Persist;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.StepDataBinding;
import com.boozallen.aiops.mda.metamodel.element.java.JavaPersist;
import com.boozallen.aiops.mda.metamodel.element.java.JavaStepDataBinding;
import com.boozallen.aiops.mda.metamodel.element.java.JavaStepDataCollectionType;
import com.boozallen.aiops.mda.metamodel.element.java.JavaStepDataRecordType;
import com.boozallen.aiops.mda.metamodel.element.util.JavaElementUtils;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.TypeManager;
import org.technologybrewery.fermenter.mda.generator.GenerationException;
import org.technologybrewery.fermenter.mda.metamodel.ModelInstanceRepositoryManager;

public class JavaStep
extends BaseStepDecorator {
    private static final String VOID = "void";
    private static final String MESSAGE = "message";
    private static final String MULTI_MESSAGE = "multimessage";
    private static final String DATASET = "dataset";
    private static final String ROW = "row";
    private static final String STRING = "string";
    private static final String IO_SMALLRYE_MUTINY_UNI = "io.smallrye.mutiny.Uni";
    private Set<String> imports = new TreeSet<String>();
    private AIOpsModelInstanceRepostory metamodelRepository = (AIOpsModelInstanceRepostory)((Object)ModelInstanceRepositoryManager.getMetamodelRepository(AIOpsModelInstanceRepostory.class));

    public JavaStep(Step stepToDecorate) {
        super(stepToDecorate);
    }

    @Override
    public Persist getPersist() {
        return super.getPersist() != null ? new JavaPersist(super.getPersist()) : null;
    }

    @Override
    public JavaStepDataBinding getInbound() {
        return super.getInbound() != null ? new JavaStepDataBinding(super.getInbound()) : null;
    }

    @Override
    public JavaStepDataBinding getOutbound() {
        return super.getOutbound() != null ? new JavaStepDataBinding(super.getOutbound()) : null;
    }

    public String getBaseSignature() {
        String inputType = this.getBaseInboundType();
        String outboundType = this.getBaseOutboundType();
        return this.createSignature("executeStep", "public", inputType, outboundType, false);
    }

    public String getAbstractImplSignature() {
        return this.getImplSignature(true);
    }

    public String getConcreteImplSignature() {
        return this.getImplSignature(false);
    }

    public String getEncryptionSignature() {
        String inputType = this.getBaseInboundType();
        return this.createSignature("checkAndApplyEncryptionPolicy", "protected", inputType, inputType, false);
    }

    private String getImplSignature(boolean isAbstract) {
        String outboundType;
        String inputType;
        if ("asynchronous".equalsIgnoreCase(this.getType())) {
            inputType = this.getBaseInboundType();
            outboundType = this.getBaseOutboundType();
        } else {
            inputType = this.getImplInboundType();
            outboundType = this.getImplOutboundType();
        }
        return this.createSignature("executeStepImpl", "protected", inputType, outboundType, isAbstract);
    }

    private String createSignature(String methodName, String visibility, String inputType, String outputType, boolean isAbstract) {
        StringBuilder builder = new StringBuilder();
        builder.append(visibility).append(" ");
        if (isAbstract) {
            builder.append("abstract ");
        }
        builder.append(outputType).append(" ");
        builder.append(methodName).append("(");
        if (StringUtils.isNotBlank((CharSequence)inputType)) {
            builder.append(inputType);
            builder.append(" inbound");
        }
        builder.append(")");
        return builder.toString();
    }

    public boolean hasVoidInbound() {
        return this.isVoid(this.getInbound());
    }

    public boolean hasVoidOutbound() {
        return this.isVoid(this.getOutbound());
    }

    public boolean useEmitter() {
        return this.hasNativeInbound() || this.hasVoidInbound();
    }

    public Set<String> getBaseImports() {
        this.getBaseSignature();
        this.addPersistImports();
        return this.imports;
    }

    public Set<String> getImplImports() {
        this.getImplSignature(false);
        return this.imports;
    }

    @Override
    public boolean isMessaging(StepDataBinding stepDataBinding) {
        return stepDataBinding != null && "messaging".equalsIgnoreCase(stepDataBinding.getType());
    }

    @Override
    public boolean isMultiMessaging(StepDataBinding stepDataBinding) {
        return stepDataBinding != null && "multimessaging".equalsIgnoreCase(stepDataBinding.getType());
    }

    public String getOutgoingChannel() {
        if (!this.hasMessagingOutbound()) {
            throw new GenerationException("Cannot retrieve outgoing channel name for non-messaging outbound: " + this.getName());
        }
        return this.getHyphenatedName() + "-out";
    }

    public String getIncomingChannel() {
        if (!this.hasMessagingInbound()) {
            throw new GenerationException("Cannot retrieve incoming channel name for non-messaging inbound: " + this.getName());
        }
        return this.getHyphenatedName() + "-in";
    }

    private String getHyphenatedName() {
        Object[] nameParts = StringUtils.splitByCharacterTypeCamelCase((String)this.getName());
        return StringUtils.join((Object[])nameParts, (char)'-').toLowerCase();
    }

    public boolean isVoid(StepDataBinding stepDataBinding) {
        return stepDataBinding == null || VOID.equalsIgnoreCase(stepDataBinding.getType());
    }

    public String getBaseInboundType() {
        Object inboundType = null;
        String implInboundType = this.getImplInboundType();
        if (this.hasMessagingInbound()) {
            String messageType = TypeManager.getShortType((String)MESSAGE);
            inboundType = messageType + "<" + implInboundType + ">";
            if (this.isMultiMessaging(this.getInbound())) {
                inboundType = TypeManager.getShortType((String)MULTI_MESSAGE) + "<" + (String)inboundType + ">";
            }
            this.addImport(TypeManager.getFullyQualifiedType((String)"incoming"));
            this.addImport(TypeManager.getFullyQualifiedType((String)MESSAGE));
        } else if (!this.hasVoidInbound()) {
            inboundType = implInboundType;
        }
        return inboundType;
    }

    public String getBaseOutboundType() {
        if ("asynchronous".equalsIgnoreCase(this.getType())) {
            return this.getAsyncBaseOutboundType();
        }
        return this.getSyncBaseOutboundType();
    }

    public String getAsyncBaseOutboundType() {
        Object outboundType = "CompletionStage";
        JavaStepDataBinding outbound = this.getOutbound();
        String implOutboundType = this.getImplOutboundType();
        if (outbound == null) {
            outboundType = (String)outboundType + "<Void>";
        } else {
            ArrayList<Object> types = new ArrayList<Object>();
            if (this.isMessaging(outbound)) {
                types.add("<Message");
            }
            if (this.isMultiMessaging(this.getOutbound())) {
                types.add("<Message");
                outboundType = "Publisher";
            }
            if (implOutboundType != null) {
                types.add("<" + implOutboundType);
            }
            StringBuilder builder = new StringBuilder();
            types.forEach(builder::append);
            types.forEach(type -> builder.append(">"));
            outboundType = (String)outboundType + builder.toString();
        }
        return outboundType;
    }

    public String getSyncBaseOutboundType() {
        Object outboundType = "";
        String implOutboundType = this.getImplOutboundType();
        boolean hasMessagingInbound = this.hasMessagingInbound();
        JavaStepDataBinding outbound = this.getOutbound();
        if (outbound == null && hasMessagingInbound) {
            outboundType = "Uni<Void>";
            this.addImport(IO_SMALLRYE_MUTINY_UNI);
        } else if (this.hasVoidOutbound() || this.hasMessagingOutbound() && this.hasNativeInbound()) {
            outboundType = VOID;
        } else if (this.hasMessagingOutbound()) {
            if (this.hasMultiMessagingOutbound()) {
                outboundType = TypeManager.getShortType((String)MULTI_MESSAGE) + "<" + TypeManager.getShortType((String)MESSAGE) + ">";
                this.addImport(TypeManager.getFullyQualifiedType((String)MULTI_MESSAGE));
            } else {
                String messageType = TypeManager.getShortType((String)MESSAGE);
                outboundType = messageType + "<" + implOutboundType + ">";
            }
            this.addImport(TypeManager.getFullyQualifiedType((String)"outgoing"));
            this.addImport(TypeManager.getFullyQualifiedType((String)MESSAGE));
        } else if (hasMessagingInbound) {
            outboundType = "Uni<" + implOutboundType + ">";
            this.addImport(IO_SMALLRYE_MUTINY_UNI);
        } else {
            outboundType = implOutboundType;
        }
        return outboundType;
    }

    public String getImplInboundType() {
        JavaStepDataBinding inbound = this.getInbound();
        return this.deriveImplType(inbound);
    }

    public String getImplOutboundType() {
        JavaStepDataBinding outbound = this.getOutbound();
        String outboundType = this.hasVoidOutbound() ? VOID : this.deriveImplType(outbound);
        return outboundType;
    }

    private String deriveImplType(StepDataBinding dataBinding) {
        Object implementationType = null;
        String javaNativeCollectionTypeName = null;
        String javaNativeCollectionImportName = null;
        String javaRecordTypeName = null;
        String javaRecordImportName = null;
        if (this.hasRecordType(dataBinding)) {
            JavaStepDataRecordType javaRecordType = new JavaStepDataRecordType(dataBinding.getRecordType());
            javaRecordTypeName = javaRecordType.getName();
            javaRecordImportName = javaRecordType.getFullyQualifiedType();
        } else if (this.isMessaging(dataBinding) || this.isMultiMessaging(dataBinding)) {
            javaRecordTypeName = TypeManager.getShortType((String)STRING);
            javaRecordImportName = TypeManager.getFullyQualifiedType((String)STRING);
        } else if (this.isNative(dataBinding)) {
            javaRecordTypeName = TypeManager.getShortType((String)ROW);
            javaRecordImportName = TypeManager.getFullyQualifiedType((String)ROW);
        }
        if (this.isNative(dataBinding)) {
            if (dataBinding.getNativeCollectionType() != null) {
                JavaStepDataCollectionType javaNativeCollectionType = new JavaStepDataCollectionType(dataBinding.getNativeCollectionType());
                javaNativeCollectionTypeName = javaNativeCollectionType.getShortType();
                javaNativeCollectionImportName = javaNativeCollectionType.getFullyQualifiedType();
            } else {
                javaNativeCollectionTypeName = TypeManager.getShortType((String)DATASET);
                javaNativeCollectionImportName = TypeManager.getFullyQualifiedType((String)DATASET);
            }
            this.addImport(javaNativeCollectionImportName);
        }
        if (StringUtils.isNotBlank(javaNativeCollectionTypeName)) {
            implementationType = javaNativeCollectionTypeName + "<" + javaRecordTypeName + ">";
            this.addRecordImports(javaRecordImportName);
        } else if (!this.isVoid(dataBinding)) {
            implementationType = javaRecordTypeName;
            this.addRecordImports(javaRecordImportName);
        }
        return implementationType;
    }

    private void addImport(String importValue) {
        if (JavaElementUtils.isImportNeeded(importValue)) {
            this.imports.add(importValue);
        }
    }

    private void addPersistImports() {
        JavaPersist javaPersist = (JavaPersist)this.getPersist();
        if (javaPersist != null) {
            for (String importValue : javaPersist.getImports()) {
                this.addImport(importValue);
            }
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (this.hasMessagingInbound() && this.hasNativeOutbound()) {
            throw new GenerationException("Step '" + this.getName() + "' uses messaging inbound and native outbound. This combination cannot be used together as it is not possible for a synchronous consumer to be listening for an asynchonrous event without also messaging being used as the outbound type.");
        }
    }

    public String getNativeCollectionInstantiationType() {
        String instantationType = null;
        if (this.getInbound() != null && this.getInbound().getNativeCollectionType() != null) {
            DictionaryType dictionaryType = this.getInbound().getNativeCollectionType().getDictionaryType();
            String simpleType = dictionaryType.getSimpleType();
            String fullyQualifiedType = TypeManager.getFullyQualifiedType((String)simpleType);
            instantationType = "java.util.List".equals(fullyQualifiedType) ? "ArrayList" : ("java.util.Set".equals(fullyQualifiedType) ? "HashSet" : TypeManager.getShortType((String)simpleType));
        }
        return instantationType;
    }

    public String getLowerCamelCaseName() {
        return PipelineUtils.deriveLowerCamelNameFromUpperCamelName(this.getName());
    }

    private void addRecordImports(String importName) {
        String packageName = importName.substring(0, importName.lastIndexOf(46));
        String className = importName.substring(importName.lastIndexOf(46) + 1);
        Record record = this.metamodelRepository.getRecord(packageName, className);
        this.imports.add(importName);
        if (record != null) {
            this.imports.add(record.getPackage() + "." + record.getName() + "Schema");
        }
    }
}

