/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.pyspark;

import com.boozallen.aiops.mda.generator.common.FrameworkEnum;
import com.boozallen.aiops.mda.metamodel.element.Framework;
import com.boozallen.aiops.mda.metamodel.element.FrameworkElement;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.python.PythonRecord;
import com.boozallen.aiops.mda.metamodel.element.util.PythonElementUtils;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class PySparkRecord
extends PythonRecord {
    private static final String ROW_PACKAGE = "pyspark.sql.Row";
    private Set<String> imports = new TreeSet<String>();

    public PySparkRecord(Record recordToDecorate) {
        super(recordToDecorate);
    }

    @Override
    public Set<String> getBaseImports() {
        this.imports.addAll(super.getBaseImports());
        String rowImport = PythonElementUtils.derivePythonImport(ROW_PACKAGE);
        this.imports.add(rowImport);
        return this.imports;
    }

    @Override
    public List<Framework> getFrameworks() {
        List<Framework> frameworks = super.getFrameworks();
        FrameworkElement pySparkFramework = new FrameworkElement();
        pySparkFramework.setName(FrameworkEnum.PYSPARK);
        frameworks.add(pySparkFramework);
        return frameworks;
    }

    public boolean hasFramework(String framework) {
        return this.getFrameworks().stream().anyMatch(fw -> fw.getName().equalsIgnoreCase(framework));
    }
}

