/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.pyspark;

import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.pyspark.PySparkDictionaryType;
import com.boozallen.aiops.mda.metamodel.element.pyspark.PySparkRecordField;
import com.boozallen.aiops.mda.metamodel.element.pyspark.PySparkRecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.python.PythonRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PySparkSchemaRecord
extends PythonRecord {
    private static final Logger logger = LoggerFactory.getLogger(PySparkSchemaRecord.class);
    private Set<String> imports = new TreeSet<String>();

    public PySparkSchemaRecord(Record recordToDecorate) {
        super(recordToDecorate);
    }

    @Override
    public List<RecordField> getFields() {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (RecordField field : this.wrapped.getFields()) {
            PySparkRecordField pySparkField = new PySparkRecordField(field);
            PySparkRecordFieldType fieldType = (PySparkRecordFieldType)pySparkField.getType();
            if (fieldType.isDictionaryTyped()) {
                fields.add(pySparkField);
                continue;
            }
            logger.warn("PySpark schema does not support composite type - skip adding field '{}' to PySpark schema.", (Object)pySparkField.getName());
        }
        return fields;
    }

    @Override
    public Set<String> getBaseImports() {
        for (RecordField field : this.getFields()) {
            PySparkRecordField pySparkField = (PySparkRecordField)field;
            PySparkRecordFieldType fieldType = (PySparkRecordFieldType)pySparkField.getType();
            PySparkDictionaryType dictionaryType = (PySparkDictionaryType)fieldType.getDictionaryType();
            String dictionaryTypeImport = dictionaryType.getSimpleTypeImport();
            if (!StringUtils.isNotBlank((CharSequence)dictionaryTypeImport)) continue;
            this.imports.add(dictionaryTypeImport);
        }
        return this.imports;
    }
}

