/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.python;

import com.boozallen.aiops.mda.metamodel.element.BaseDictionaryTypeDecorator;
import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.util.PythonElementUtils;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class PythonDictionaryType
extends BaseDictionaryTypeDecorator {
    private static final List<String> VALIDATABLE_TYPES = Arrays.asList("Decimal", "float", "int", "str");

    public PythonDictionaryType(DictionaryType dictionaryTypeToDecorate) {
        super(dictionaryTypeToDecorate);
    }

    @Override
    public String getSimpleType() {
        return super.getSimpleType() + "-python";
    }

    @Override
    public void validate() {
        super.validate();
        this.validateValidations(VALIDATABLE_TYPES, this.isString(), this.isDecimal());
    }

    public String getSnakeCaseName() {
        return PythonElementUtils.getSnakeCaseValue(this.getName());
    }

    public String getSimpleTypeImport() {
        String fullyQualifiedType = this.getFullyQualifiedType();
        String fullyQualfiedImport = PythonElementUtils.derivePythonImport(fullyQualifiedType);
        return StringUtils.isNotBlank((CharSequence)fullyQualfiedImport) ? fullyQualfiedImport : null;
    }

    public String getGeneratedClassImport() {
        String generatedClassImport = null;
        if (this.isComplex()) {
            String pythonPackage = "...dictionary." + this.getSnakeCaseName();
            String generatedClassType = pythonPackage + "." + this.getCapitalizedName();
            generatedClassImport = PythonElementUtils.derivePythonImport(generatedClassType);
        }
        return generatedClassImport;
    }

    public String getCommaSeparatedFormats() {
        StringJoiner stringJoiner = new StringJoiner(", ");
        if (this.hasFormatValidation()) {
            for (String format : this.getValidation().getFormats()) {
                stringJoiner.add("'" + format + "'");
            }
        }
        return stringJoiner.toString();
    }

    public boolean isString() {
        return "str".equals(this.getShortType());
    }

    public boolean isDecimal() {
        return "Decimal".equals(this.getShortType()) || "float".equals(this.getShortType());
    }
}

