/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.python;

import com.boozallen.aiops.mda.metamodel.element.BaseRecordDecorator;
import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.python.PythonDictionaryType;
import com.boozallen.aiops.mda.metamodel.element.python.PythonRecordField;
import com.boozallen.aiops.mda.metamodel.element.python.PythonRecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.util.PythonElementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.generator.GenerationException;

public class PythonRecord
extends BaseRecordDecorator {
    private Set<String> imports = new TreeSet<String>();

    public PythonRecord(Record recordToDecorate) {
        super(recordToDecorate);
    }

    @Override
    public List<RecordField> getFields() {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (RecordField field : super.getFields()) {
            fields.add(new PythonRecordField(field));
        }
        return fields;
    }

    public String getSnakeCaseName() {
        return PythonElementUtils.getSnakeCaseValue(this.getName());
    }

    public Set<String> getBaseImports() {
        for (RecordField field : this.getFields()) {
            PythonRecordField pythonField = (PythonRecordField)field;
            this.addFieldImports(pythonField, false);
        }
        return this.imports;
    }

    public Set<String> getEnumImports() {
        for (RecordField field : this.getFields()) {
            PythonRecordField pythonField = (PythonRecordField)field;
            if (!this.hasDriftPolicy(pythonField) && !this.hasEthicsPolicy(pythonField) && !this.hasProtectionPolicy(pythonField)) continue;
            this.addFieldImports(pythonField, true);
        }
        return this.imports;
    }

    private boolean hasDriftPolicy(PythonRecordField pythonField) {
        return StringUtils.isNotBlank((CharSequence)pythonField.getDriftPolicy()) && !pythonField.hasOverriddenDriftPolicy();
    }

    private boolean hasEthicsPolicy(PythonRecordField oythonField) {
        return StringUtils.isNotBlank((CharSequence)oythonField.getEthicsPolicy()) && !oythonField.hasOverriddenEthicsPolicy();
    }

    private boolean hasProtectionPolicy(PythonRecordField pythonField) {
        return StringUtils.isNotBlank((CharSequence)pythonField.getProtectionPolicy()) && !pythonField.hasOverriddenProtectionPolicy();
    }

    private void addFieldImports(PythonRecordField field, boolean forEnum) {
        PythonRecordFieldType fieldType = (PythonRecordFieldType)field.getType();
        if (fieldType.isDictionaryTyped()) {
            PythonDictionaryType dictionaryType = (PythonDictionaryType)fieldType.getDictionaryType();
            this.addDictionaryTypeImports(dictionaryType, forEnum);
        } else if (fieldType.isCompositeTyped()) {
            throw new GenerationException("Composite typed field not supported yet!");
        }
    }

    private void addDictionaryTypeImports(PythonDictionaryType dictionaryType, boolean forEnum) {
        String simpleTypeImport;
        if (dictionaryType.isComplex()) {
            String generatedClassImport = dictionaryType.getGeneratedClassImport();
            this.imports.add(generatedClassImport);
        }
        if (!forEnum && StringUtils.isNotBlank((CharSequence)(simpleTypeImport = dictionaryType.getSimpleTypeImport()))) {
            this.imports.add(simpleTypeImport);
        }
    }
}

