/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.python;

import com.boozallen.aiops.mda.generator.util.PipelineUtils;
import com.boozallen.aiops.mda.metamodel.element.BaseStepDecorator;
import com.boozallen.aiops.mda.metamodel.element.Persist;
import com.boozallen.aiops.mda.metamodel.element.Step;
import com.boozallen.aiops.mda.metamodel.element.StepDataBinding;
import com.boozallen.aiops.mda.metamodel.element.python.PythonPersist;
import com.boozallen.aiops.mda.metamodel.element.python.PythonStepDataCollectionType;
import com.boozallen.aiops.mda.metamodel.element.python.PythonStepDataRecordType;
import com.boozallen.aiops.mda.metamodel.element.util.PythonElementUtils;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.technologybrewery.fermenter.mda.TypeManager;
import org.technologybrewery.fermenter.mda.generator.GenerationException;

public class PythonStep
extends BaseStepDecorator {
    private String profileName;
    private String rootArtifactId;
    protected static final String DATAFRAME_TYPE = "pysparkDataFrame";
    private static final String NONE = "None";
    private static final String STRING = "str";
    private Set<String> imports = new TreeSet<String>();

    public PythonStep(Step stepToDecorate) {
        super(stepToDecorate);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.hasMessagingInbound() && this.hasInboundRecordType() || this.hasMessagingOutbound() && this.hasOutboundRecordType()) {
            throw new GenerationException("Step '" + this.getName() + "' uses messaging with a record type. This combination cannot be used together as Python messaging only supports strings. Please remove the inbound and/or outbound record type from this step.");
        }
        if (this.hasMessagingInbound() && this.hasNativeOutbound()) {
            throw new GenerationException("Step '" + this.getName() + "' uses messaging inbound and native outbound. This combination cannot be used together as it is not possible for a synchronous consumer to be listening for an asynchronous event without also messaging being used as the outbound type.");
        }
    }

    @Override
    public Persist getPersist() {
        return super.getPersist() != null ? new PythonPersist(super.getPersist()) : null;
    }

    public String getLowercaseSnakeCaseName() {
        return PythonElementUtils.getSnakeCaseValue(this.getName());
    }

    public String getKababCaseName() {
        return PipelineUtils.deriveArtifactIdFromCamelCase(this.getName());
    }

    public Set<String> getBaseImports() {
        this.getBaseSignature();
        this.addPersistImports();
        return this.getImports(false);
    }

    public Set<String> getImplImports() {
        this.getConcreteSignature();
        return this.getImports(true);
    }

    private Set<String> getImports(boolean isImplModule) {
        TreeSet<String> importsSet = new TreeSet<String>();
        for (String moduleImport : this.imports) {
            if (moduleImport.startsWith("from record.") || moduleImport.startsWith("from dictionary.")) {
                if (this.profileName.equals("data-delivery-pyspark")) {
                    importsSet.add(moduleImport.replace("from ", isImplModule ? "from .." : "from ..."));
                    continue;
                }
                if (!this.profileName.equals("data-delivery-pyspark-pipeline")) continue;
                String rootArtifact = this.rootArtifactId.replace("-", "_");
                importsSet.add(moduleImport.replace("from ", "from " + rootArtifact + "_data_records."));
                continue;
            }
            importsSet.add(moduleImport);
        }
        return importsSet;
    }

    public String getBaseSignature() {
        String inputType = this.getInputType(false);
        String outputType = this.getOutputType(false);
        return this.createSignature("execute_step", inputType, outputType, this.isAsynchronous());
    }

    public String getConcreteSignature() {
        String inputType = this.getInputType(true);
        String outputType = this.getOutputType(true);
        return this.createSignature("execute_step_impl", inputType, outputType, this.isAsynchronous());
    }

    public String getEncryptionSignature() {
        String inputType = this.getInputType(true);
        String outputType = this.getOutputType(true);
        return this.createSignature("check_and_apply_encryption_policy", inputType, outputType, false);
    }

    public String getApplyEncryptionSignature() {
        String inputType = this.getInputType(true);
        String outputType = this.getOutputType(true);
        return this.createSignatureWithAdditionalParameter("apply_encryption_to_dataset", inputType, inputType, false, "fields_to_update: List[str], algorithm: str");
    }

    public String getFieldListSignature() {
        String inputType = this.getInputType(true);
        if (this.hasInboundNativeCollectionType() && !this.hasInboundRecordType()) {
            inputType = "DataFrame";
        }
        String outputType = "List[str]";
        return this.createSignature("get_fields_list", inputType, outputType, false);
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public void setRootArtifactId(String rootArtifactId) {
        this.rootArtifactId = rootArtifactId;
    }

    private String createSignature(String methodName, String inputType, String outputType, boolean asyncMethod) {
        StringBuilder builder = new StringBuilder();
        if (asyncMethod) {
            builder.append("async ");
        }
        builder.append("def ");
        builder.append(methodName);
        builder.append("(self");
        if (StringUtils.isNotBlank((CharSequence)inputType)) {
            builder.append(", ");
            builder.append("inbound: ");
            builder.append(inputType);
        }
        builder.append(") ");
        if (StringUtils.isNotBlank((CharSequence)outputType)) {
            builder.append("-> ");
            builder.append(outputType);
        }
        return builder.toString();
    }

    private String createSignatureWithAdditionalParameter(String methodName, String inputType, String outputType, boolean asyncMethod, String additionalParameter) {
        StringBuilder builder = new StringBuilder();
        if (asyncMethod) {
            builder.append("async ");
        }
        builder.append("def ");
        builder.append(methodName);
        builder.append("(self");
        if (StringUtils.isNotBlank((CharSequence)inputType)) {
            builder.append(", ");
            builder.append("inbound: ");
            builder.append(inputType);
            if (additionalParameter != null) {
                builder.append(", ");
                builder.append(additionalParameter);
            }
        }
        builder.append(") ");
        if (StringUtils.isNotBlank((CharSequence)outputType)) {
            builder.append("-> ");
            builder.append(outputType);
        }
        return builder.toString();
    }

    private String getInputType(boolean forImplMethod) {
        String inputType = null;
        if (this.hasNativeInbound()) {
            inputType = this.deriveNativeType(this.getInbound());
        } else if (this.hasMessagingInbound() && forImplMethod) {
            inputType = STRING;
        }
        return inputType;
    }

    private String getOutputType(boolean forImplMethod) {
        String outputType = this.hasNativeOutbound() ? this.deriveNativeType(this.getOutbound()) : (this.hasMessagingOutbound() && forImplMethod ? STRING : NONE);
        return outputType;
    }

    private String deriveNativeType(StepDataBinding stepDataBinding) {
        String recordTypeImport;
        String recordTypeName;
        Object nativeTypeValue = null;
        if (this.hasRecordType(stepDataBinding)) {
            PythonStepDataRecordType recordType = new PythonStepDataRecordType(stepDataBinding.getRecordType());
            recordTypeName = recordType.getName();
            recordTypeImport = recordType.getFullyQualifiedType();
        } else {
            recordTypeName = TypeManager.getShortType((String)DATAFRAME_TYPE);
            recordTypeImport = TypeManager.getFullyQualifiedType((String)DATAFRAME_TYPE);
        }
        if (stepDataBinding.getNativeCollectionType() != null) {
            PythonStepDataCollectionType collectionType = new PythonStepDataCollectionType(stepDataBinding.getNativeCollectionType());
            String collectionTypeName = collectionType.getShortType();
            String collectionTypeImport = collectionType.getFullyQualifiedType();
            nativeTypeValue = collectionTypeName + "[" + recordTypeName + "]";
            this.addImport(collectionTypeImport);
        } else {
            nativeTypeValue = recordTypeName;
        }
        this.addImport(recordTypeImport);
        return nativeTypeValue;
    }

    private void addPersistImports() {
        PythonPersist pythonPersist = (PythonPersist)this.getPersist();
        if (pythonPersist != null) {
            this.addImport(pythonPersist.getFullyQualifiedCollectionType());
            this.addImport(pythonPersist.getFullyQualifiedRecordType());
        }
    }

    private void addImport(String fullyQualifiedType) {
        String pythonImport;
        if (StringUtils.isNotBlank((CharSequence)fullyQualifiedType) && StringUtils.isNotBlank((CharSequence)(pythonImport = PythonElementUtils.derivePythonImport(fullyQualifiedType)))) {
            this.imports.add(pythonImport);
        }
    }
}

