/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.spark;

import com.boozallen.aiops.mda.metamodel.element.Record;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.java.JavaRecord;
import com.boozallen.aiops.mda.metamodel.element.java.JavaRecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.spark.SparkDictionaryType;
import com.boozallen.aiops.mda.metamodel.element.spark.SparkRecordField;
import com.boozallen.aiops.mda.metamodel.element.spark.SparkRecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.util.JavaElementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.fermenter.mda.TypeManager;

public class SparkRecord
extends JavaRecord {
    private static final Logger logger = LoggerFactory.getLogger(SparkRecord.class);
    private Set<String> imports = new TreeSet<String>();
    private static final String SPARK_DATA_TYPE_IMPORT = "org.apache.spark.sql.types.DataType";

    public SparkRecord(Record recordToDecorate) {
        super(recordToDecorate);
    }

    @Override
    public List<RecordField> getFields() {
        ArrayList<RecordField> fields = new ArrayList<RecordField>();
        for (RecordField field : super.getFields()) {
            SparkRecordField sparkField = new SparkRecordField(field);
            SparkRecordFieldType fieldType = (SparkRecordFieldType)sparkField.getType();
            if (fieldType.isDictionaryTyped()) {
                fields.add(sparkField);
                continue;
            }
            logger.warn("Spark schema does not support composite type - skip adding field '{}' to Spark schema.", (Object)sparkField.getName());
        }
        return fields;
    }

    @Override
    public Set<String> getBaseImports() {
        for (RecordField field : this.getFields()) {
            SparkRecordField sparkField = (SparkRecordField)field;
            SparkRecordFieldType fieldType = (SparkRecordFieldType)sparkField.getType();
            SparkDictionaryType dictionaryType = (SparkDictionaryType)fieldType.getDictionaryType();
            this.imports.add(dictionaryType.getFullyQualifiedType());
        }
        this.imports.add(TypeManager.getFullyQualifiedType((String)"row"));
        this.imports.add("org.apache.spark.sql.RowFactory");
        this.imports.add(TypeManager.getFullyQualifiedType((String)"dataset"));
        this.imports.add(SPARK_DATA_TYPE_IMPORT);
        return this.imports;
    }

    public Set<String> getRecordBaseImports() {
        Set<String> imports = super.getBaseImports();
        for (RecordField field : this.getFields()) {
            JavaRecordFieldType fieldType = (JavaRecordFieldType)field.getType();
            SparkDictionaryType dictionaryType = (SparkDictionaryType)fieldType.getDictionaryType();
            String simpleTypeImport = TypeManager.getFullyQualifiedType((String)dictionaryType.getGenericType());
            if (!JavaElementUtils.isImportNeeded(simpleTypeImport)) continue;
            imports.add(simpleTypeImport);
        }
        return imports;
    }
}

