/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aiops.mda.metamodel.element.util;

import com.boozallen.aiops.mda.metamodel.element.DictionaryType;
import com.boozallen.aiops.mda.metamodel.element.RecordField;
import com.boozallen.aiops.mda.metamodel.element.RecordFieldType;
import com.boozallen.aiops.mda.metamodel.element.Validation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkAttributes {
    private static final Logger logger = LoggerFactory.getLogger(SparkAttributes.class);
    private static final Integer DEFAULT_DECIMAL_PRECISION = 10;
    private static final Integer DEFAULT_DECIMAL_SCALE = 2;
    private final RecordField field;

    public SparkAttributes(RecordField field) {
        this.field = field;
    }

    public boolean isNullable() {
        return this.field.isRequired() == null || this.field.isRequired() == false;
    }

    public boolean isDecimalType() {
        boolean isDecimalType = false;
        RecordFieldType fieldType = this.field.getType();
        if (fieldType.isDictionaryTyped()) {
            DictionaryType dictionaryType = fieldType.getDictionaryType();
            String simpleType = dictionaryType.getSimpleType();
            isDecimalType = simpleType.contains("decimal");
        }
        return isDecimalType;
    }

    public Integer getDefaultDecimalPrecision() {
        return DEFAULT_DECIMAL_PRECISION;
    }

    public Integer getDecimalScale() {
        Integer scale = null;
        if (this.isDecimalType()) {
            Validation validation = this.field.getType().getDictionaryType().getValidation();
            scale = validation != null && validation.getScale() != null ? validation.getScale() : DEFAULT_DECIMAL_SCALE;
        }
        return scale;
    }

    public String getColumnName() {
        String columnName;
        if (StringUtils.isNotBlank((CharSequence)this.field.getColumn())) {
            columnName = this.field.getColumn();
        } else {
            columnName = this.field.getName();
            logger.warn("No column value found for field '{}' - defaulting Spark schema column name to field name", (Object)columnName);
        }
        return columnName;
    }
}

