/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.util.FileUtils;

public abstract class AbstractHelmNameMigration
extends AbstractAissembleMigration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHelmNameMigration.class);

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        boolean shouldExecute = false;
        try {
            List namesToUpdate = FileUtils.getRegExCaptureGroups((String)this.getReplacementRegex(file), (File)file);
            shouldExecute = CollectionUtils.isNotEmpty((Collection)namesToUpdate);
        }
        catch (IOException e) {
            throw new BatonException("Unable to determine if Helm chart migration must be executed", (Throwable)e);
        }
        return shouldExecute;
    }

    @Override
    protected boolean performMigration(File file) {
        boolean performedSuccessfully = false;
        try {
            performedSuccessfully = FileUtils.replaceInFile((File)file, (String)this.getReplacementRegex(file), (String)this.getReplacementText(file));
        }
        catch (Exception e) {
            logger.error("Unable to perform Helm chart migration due to exception", (Throwable)e);
        }
        return performedSuccessfully;
    }

    public abstract String getReplacementRegex(File var1);

    public abstract String getReplacementText(File var1);
}

