/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.util.FileUtils;

public abstract class AbstractHelmRepositoryMigration
extends AbstractAissembleMigration {
    public static final Logger logger = LoggerFactory.getLogger(AbstractHelmRepositoryMigration.class);
    private static final String OLD_HELM_REPO_PROPERTY = "oldHelmRepositoryUrl";

    protected String getOldHelmRepositoryUrl() {
        String oldHelmRepositoryUrl = System.getProperty(OLD_HELM_REPO_PROPERTY);
        if (oldHelmRepositoryUrl != null) {
            return oldHelmRepositoryUrl;
        }
        logger.info("oldHelmRepositoryUrl system property not set. Skipping helm chart repository URL migration.");
        return null;
    }

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        boolean shouldExecute = false;
        if (this.getOldHelmRepositoryUrl() != null) {
            shouldExecute = true;
        }
        return shouldExecute;
    }

    @Override
    protected boolean performMigration(File file) {
        boolean performedSuccessfully = false;
        try {
            performedSuccessfully = FileUtils.replaceInFile((File)file, (String)this.getReplacementRegex(), (String)this.getReplacementText());
        }
        catch (Exception e) {
            logger.error("Unable to perform helm chart repository URL migration due to exception", (Throwable)e);
        }
        return performedSuccessfully;
    }

    public abstract String getReplacementRegex();

    public abstract String getReplacementText();
}

