/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import com.boozallen.aissemble.upgrade.util.PythonPackageMigration;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.util.FileUtils;

public abstract class AbstractPoetryMigration
extends AbstractAissembleMigration {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPoetryMigration.class);
    public static final String DEPENDENCIES_KEY = "tool.poetry.dependencies";

    @Override
    protected boolean shouldExecuteOnFile(File file) {
        boolean shouldExecute = false;
        FileConfig poetryConfig = FileConfig.of((File)file);
        poetryConfig.load();
        Optional dependenciesOpt = poetryConfig.getOptional(DEPENDENCIES_KEY);
        if (!dependenciesOpt.isPresent()) {
            throw new BatonException(String.format("Could not get dependencies for file %s", file.getAbsolutePath()));
        }
        Config dependencies = (Config)dependenciesOpt.get();
        shouldExecute = this.hasOldPackages(dependencies);
        return shouldExecute;
    }

    private boolean hasOldPackages(Config currentPackages) {
        boolean hasOldPackages = false;
        for (PythonPackageMigration packageMigration : this.getPythonPackageMigrations()) {
            if (!currentPackages.contains(packageMigration.getOldName())) continue;
            hasOldPackages = true;
            break;
        }
        return hasOldPackages;
    }

    @Override
    protected boolean performMigration(File file) {
        boolean performedSuccessfully = false;
        FileConfig pyproject = FileConfig.of((File)file);
        pyproject.load();
        Config dependencies = (Config)pyproject.get(DEPENDENCIES_KEY);
        try {
            performedSuccessfully = this.migrateOldPythonPackages(dependencies, file);
        }
        catch (IOException e) {
            throw new BatonException("Could not migrate file: " + file.getPath(), (Throwable)e);
        }
        return performedSuccessfully;
    }

    private boolean migrateOldPythonPackages(Config config, File pyproject) throws IOException {
        boolean success = false;
        for (PythonPackageMigration packageMigration : this.getPythonPackageMigrations()) {
            String oldPackageName = packageMigration.getOldName();
            if (!config.getOptional(oldPackageName).isPresent()) continue;
            String regex = String.format("%s = \".+\"", packageMigration.getOldName());
            String replacement = String.format("%s = \"%s\"", packageMigration.getNewName(), packageMigration.getNewVersion());
            FileUtils.replaceInFile((File)pyproject, (String)regex, (String)replacement);
            logger.info("Replacing Python package {} -> {} = \"{}\"", new Object[]{packageMigration.getOldName(), packageMigration.getNewName(), packageMigration.getNewVersion()});
            success = true;
        }
        return success;
    }

    public abstract Set<PythonPackageMigration> getPythonPackageMigrations();
}

