/*
 * Decompiled with CFR 0.152.
 */
package com.boozallen.aissemble.upgrade.migration;

import com.boozallen.aissemble.upgrade.migration.AbstractAissembleMigration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.technologybrewery.baton.BatonException;
import org.technologybrewery.baton.util.pom.LocationAwareMavenReader;
import org.technologybrewery.baton.util.pom.PomModifications;

public abstract class AbstractPomMigration
extends AbstractAissembleMigration {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractPomMigration.class);
    public static final String POM = "pom";
    public static final String GUARANTEED_TAG = "<modelVersion>";
    protected String indent;

    protected void detectAndSetIndent(File file) {
        try (Stream<String> lines = Files.lines(file.toPath());){
            this.indent = lines.filter(line -> line.contains(GUARANTEED_TAG)).findFirst().map(artifact -> artifact.substring(0, artifact.indexOf(GUARANTEED_TAG))).orElse(null);
            if (StringUtils.isEmpty((CharSequence)this.indent)) {
                logger.info("Failed to detect indent for POM. Using default. {}", (Object)file);
                this.indent = "    ";
            }
        }
        catch (IOException e) {
            throw new BatonException("Failed to get indent from POM:" + file, (Throwable)e);
        }
    }

    protected boolean hasDependency(Model model, String groupId, String artifactId) {
        return model.getDependencies().stream().anyMatch(dependency -> dependency.getGroupId().equals(groupId) && dependency.getArtifactId().contains(artifactId));
    }

    protected List<Dependency> getMatchingDependenciesForProject(Model model, Predicate<? super Dependency> filter) {
        List<Dependency> matchingDependencies = this.getMatchingDependencies((ModelBase)model, filter);
        for (Profile profile : model.getProfiles()) {
            matchingDependencies.addAll(this.getMatchingDependencies((ModelBase)profile, filter));
        }
        return matchingDependencies;
    }

    private List<Dependency> getMatchingDependencies(ModelBase model, Predicate<? super Dependency> filter) {
        ArrayList<Dependency> matchingDependencies = new ArrayList<Dependency>();
        Stream.concat(model.getDependencies().stream().filter(filter), Optional.ofNullable(model.getDependencyManagement()).map(dependencyManagement -> dependencyManagement.getDependencies().stream().filter(filter)).orElse(Stream.empty())).forEach(matchingDependencies::add);
        return matchingDependencies;
    }

    protected static PomModifications.Replacement replaceInTag(InputLocationTracker container, String tag, String contents) {
        InputLocation start = container.getLocation((Object)tag);
        InputLocation end = container.getLocation((Object)(tag + LocationAwareMavenReader.END));
        end = new InputLocation(end.getLineNumber(), end.getColumnNumber() - tag.length() - "</>".length(), end.getSource());
        return new PomModifications.Replacement(start, end, contents);
    }

    protected static PomModifications.Deletion deleteTag(InputLocationTracker container, String tag) {
        InputLocation start = container.getLocation((Object)(tag + LocationAwareMavenReader.START));
        InputLocation end = container.getLocation((Object)(tag + LocationAwareMavenReader.END));
        return new PomModifications.Deletion(start, end);
    }
}

